/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.basic.contracts.common;

import com.namasoft.common.criteria.DTOCriteriaBuilder;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.modules.basic.contracts.common.GeneratedDTOAPPSConfiguration;
import com.namasoft.modules.basic.contracts.details.DTOAPPMobileDocOrFileConfig;
import com.namasoft.modules.basic.contracts.details.GeneratedDTOAPPBookWarehouseConfigLine;
import com.namasoft.modules.basic.contracts.details.GeneratedDTOAppsConfigMobileDeliveryLine;
import com.namasoft.modules.basic.contracts.details.GeneratedDTOAppsConfigMobileShopLine;
import com.namasoft.modules.basic.contracts.valueobjects.DTOMobileShopCountryConfig;
import com.namasoft.modules.basic.enums.AttendanceOptions;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOAPPSConfiguration
extends GeneratedDTOAPPSConfiguration
implements Serializable {
    public DTOCriteriaBuilder.DTOExpressionBuilder itemLevelsCriteria(DTOGenericDimensions dimensions, String country, String level1PId, String level2PId, String level3PId) {
        DTOCriteriaBuilder.DTOExpressionBuilder builder = DTOCriteriaBuilder.create().dummy();
        builder = this.buildLevelCriteria(builder, level1PId, this.fetchLevelOne(dimensions, country));
        builder = this.buildLevelCriteria(builder, level2PId, this.fetchLevelTwo(dimensions, country));
        builder = this.buildLevelCriteria(builder, level3PId, this.fetchLevelThree(dimensions, country));
        return builder;
    }

    public EntityReferenceData ordersItemsSendingCriteria(String deviceID) {
        return this.getOrdersConfigLines().stream().filter(l -> ObjectChecker.areEqual((Object)l.getDeviceId(), (Object)deviceID) || ObjectChecker.isEmptyOrNull((Object)l.getDeviceId())).findFirst().map(GeneratedDTOAPPBookWarehouseConfigLine::getOrdersItemsSendingCriteria).orElse(this.getOrdersItemsSendingCriteria());
    }

    public EntityReferenceData ordersCustomersSendingCriteria(String deviceID) {
        return this.getOrdersConfigLines().stream().filter(l -> ObjectChecker.areEqual((Object)l.getDeviceId(), (Object)deviceID) || ObjectChecker.isEmptyOrNull((Object)l.getDeviceId())).findFirst().map(GeneratedDTOAPPBookWarehouseConfigLine::getOrdersCustomersSendingCriteria).orElse(this.getOrdersCustomersSendingCriteria());
    }

    public String fetchLevelOne(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getLevelOne();
    }

    public String fetchLevelTwo(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getLevelTwo();
    }

    public String fetchLevelThree(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getLevelThree();
    }

    public EntityReferenceData fetchLevelOneCriteria(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getLevelOneCriteria();
    }

    public EntityReferenceData fetchLevelTwoCriteria(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getLevelTwoCriteria();
    }

    public EntityReferenceData fetchLevelThreeCriteria(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getLevelThreeCriteria();
    }

    public EntityReferenceData fetchItemsCriteria(DTOGenericDimensions dimensions, String country) {
        return this.findConfigForCountry(dimensions, country).getItemsCriteria();
    }

    public DTOMobileShopCountryConfig findConfigForCountry(DTOGenericDimensions dimensions, String country) {
        return this.getShoppingLines().stream().filter(l -> l.isMatched(dimensions, country)).findFirst().map(GeneratedDTOAppsConfigMobileShopLine::getConfig).orElse(this.getConfig());
    }

    public DTOMobileShopCountryConfig findConfigForCountry(String country) {
        return this.findConfigForCountry(null, country);
    }

    private DTOCriteriaBuilder.DTOExpressionBuilder buildLevelCriteria(DTOCriteriaBuilder.DTOExpressionBuilder builder, String levelId, String entityType) {
        if (ObjectChecker.isEmptyOrNull((Object)entityType)) {
            return builder;
        }
        if (ObjectChecker.areEqual((Object)entityType, (Object)"ItemSection")) {
            return builder.and().field("section").equal(levelId);
        }
        return builder.and().field(StringUtils.firstLetterLower((String)entityType)).equal(levelId);
    }

    public EntityReferenceData deliveryItemsSendingCriteria(String deviceId) {
        if (ObjectChecker.isEmptyOrNull(this.getDeliveryLines())) {
            return this.getDeliveryItemsSendingCriteria();
        }
        return this.getDeliveryLines().stream().filter(l -> ObjectChecker.areEqual((Object)l.getDeviceId(), (Object)deviceId) || ObjectChecker.isEmptyOrNull((Object)l.getDeviceId())).findFirst().map(GeneratedDTOAppsConfigMobileDeliveryLine::getDeliveryItemsSendingCriteria).orElse(this.getDeliveryItemsSendingCriteria());
    }

    public boolean docOrFileConfigListDoesNotHaveDynamicCriteria(String mobileEntityType, String deviceCode) {
        return this.getDocOrFileConfigList().stream().filter(l -> l.matched(deviceCode, mobileEntityType)).noneMatch(DTOAPPMobileDocOrFileConfig::containsDynamicCriteria);
    }

    public boolean shouldShowDraftDocsInMobile() {
        return ObjectChecker.isTrue((Boolean)this.getShowDraftDocsInMobile());
    }

    public String fetchAttendanceOptions() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getAttendanceOptions())) {
            return AttendanceOptions.AttendingAndLeaving.name();
        }
        return this.getAttendanceOptions();
    }

    public Integer fetchMobileRequestInSeconds() {
        if (ObjectChecker.isEmptyOrZero((Integer)this.getMobileRequestTimeOutInSeconds())) {
            return 60;
        }
        return this.getMobileRequestTimeOutInSeconds();
    }

    public Integer fetchMobileDetailsMaxLength() {
        if (ObjectChecker.isEmptyOrZero((Integer)this.getMobileDetailsMaxLength())) {
            return 500;
        }
        return this.getMobileDetailsMaxLength();
    }
}

