/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.httpcommon;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.namasoft.common.flatobjects.http.HttpRequest;
import com.namasoft.common.flatobjects.http.NameValue;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.httpcommon.HttpClient;
import com.namasoft.httpcommon.oauth.HttpMethod;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public class DefaultHttpClient
implements HttpClient,
Closeable {
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String fetchUrl(String url) throws URISyntaxException, IOException {
        try (DefaultHttpClient client = new DefaultHttpClient();){
            String string = client.send(new HttpRequest().url(url).get());
            return string;
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Override
    public CloseableHttpClient httpClient() {
        return this.httpClient;
    }

    public static void main(String[] args) throws URISyntaxException, IOException {
        HttpRequest req = new HttpRequest();
        req.setUrl("https://eu-chatbot-restaurant.kait.ai/kuwait_post/send_shipment_update_template");
        req.addHeader("api-key", "fxxm7lqpjqqfuwzenxyh");
        req.setContentType("application/json");
        req.addBodyPart("user_whatsapp_number", (Object)"201096744560");
        req.addBodyPart("order_number", (Object)"abc123");
        System.out.println(new DefaultHttpClient().send(req));
    }

    public String send(HttpRequest request) throws URISyntaxException, IOException {
        return this.sendAndGetDetailedResponse((HttpRequest)request, (boolean)true).response;
    }

    public HttpSendResponse sendAndGetDetailedResponse(HttpRequest request, boolean handleErrorsByException) throws URISyntaxException, IOException {
        Object entity;
        URIBuilder uriBuilder = new URIBuilder(request.getUrl());
        String mimeType = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{request.getContentType(), ContentType.APPLICATION_JSON.getMimeType()});
        String charSet = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{request.getCharSet(), "utf-8"});
        ContentType contentType = ContentType.create((String)mimeType, (String)charSet);
        List<Object> parametersAsList = new ArrayList();
        if (request.getParameters() != null) {
            parametersAsList = request.getParameters().stream().map(nv -> new BasicNameValuePair(nv.getName(), nv.getValue() == null ? null : nv.getValue().toString())).collect(Collectors.toList());
        }
        HttpMethod method = HttpMethod.valueOf(request.getMethod().toUpperCase());
        String bodyStr = request.getBody();
        if (ObjectChecker.isNotEmptyOrNull((Object)request.getJsonBody())) {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (NameValue nv2 : request.getJsonBody()) {
                map.put(nv2.getName(), nv2.getValue());
            }
            bodyStr = this.mapper().writeValueAsString(map);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)bodyStr)) {
            uriBuilder.addParameters(parametersAsList);
            entity = ObjectChecker.areNotEqual((Object)bodyStr, (Object)"@@#empty#@@") ? new ByteArrayEntity(bodyStr.getBytes(contentType.getCharset()), contentType) : null;
        } else if (ObjectChecker.areEqual((Object)contentType.getMimeType(), (Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            entity = new UrlEncodedFormEntity(parametersAsList, contentType.getCharset());
        } else {
            uriBuilder.addParameters(parametersAsList);
            entity = null;
        }
        HttpUriRequestBase httpReq = this.createMethodRequest(method, uriBuilder);
        httpReq.setEntity((HttpEntity)entity);
        NameValue contentTypeHeader = request.getHeaders().stream().filter(p -> ObjectChecker.areEqual((Object)p.getName(), (Object)"Content-Type")).findFirst().orElse(null);
        if (contentTypeHeader == null || ObjectChecker.isEmptyOrNull((Object)contentTypeHeader.getValue())) {
            httpReq.setHeader("Content-Type", (Object)contentType.getMimeType());
        }
        httpReq.setConfig(REQUESTS_CONFIG);
        for (NameValue header : request.getHeaders()) {
            httpReq.addHeader(header.getName(), header.getValue() == null ? null : header.getValue().toString());
        }
        return this.getEntityAndReleaseConnection(httpReq, handleErrorsByException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpSendResponse getEntityAndReleaseConnection(HttpUriRequestBase httpRequest, boolean handleErrorsByException) {
        try (CloseableHttpResponse httpResponse = this.httpClient().execute((ClassicHttpRequest)httpRequest);){
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                throw new RuntimeException("Error retrieving results from http request");
            }
            if (handleErrorsByException) {
                this.checkValidResponse(httpResponse);
            }
            HttpClient.ResultAsSTR result = this.parseResponseContent(httpEntity.getContent(), HttpClient.ResultAsSTR.class);
            if (!this.ifValidResponse((HttpResponse)httpResponse)) {
                HttpSendResponse httpSendResponse2 = HttpSendResponse.error(httpResponse.getCode(), result.result);
                return httpSendResponse2;
            }
            HttpSendResponse httpSendResponse = HttpSendResponse.success(httpResponse.getCode(), result.result);
            return httpSendResponse;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public static class HttpSendResponse {
        private String response;
        private String error;
        private int status;
        private boolean isFailure;

        public static HttpSendResponse success(int status, String response) {
            HttpSendResponse resp = new HttpSendResponse();
            resp.isFailure = false;
            resp.status = status;
            resp.response = response;
            resp.error = null;
            return resp;
        }

        public static HttpSendResponse error(int status, String error) {
            HttpSendResponse resp = new HttpSendResponse();
            resp.isFailure = true;
            resp.status = status;
            resp.error = error;
            resp.response = null;
            return resp;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public boolean isFailure() {
            return this.isFailure;
        }

        public void setFailure(boolean failure) {
            this.isFailure = failure;
        }
    }
}

