/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.httpcommon.oauth;

import com.namasoft.httpcommon.oauth.HttpMethod;
import com.namasoft.httpcommon.oauth.OAuthConfig;
import com.namasoft.httpcommon.oauth.OAuthHeader;
import com.namasoft.httpcommon.oauth.SignatureAlgorithm;
import com.namasoft.httpcommon.oauth.SignatureMethodType;
import com.namasoft.httpcommon.oauth.SpecialSymbol;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hc.client5.http.utils.Base64;

public class OAuthSignature {
    private static final String BASE_SIGNATURE_FORMAT = "%s&%s&%s";
    private static final String DELETE_PARAM_FORCE = "force";

    private OAuthSignature() {
    }

    public static Map<String, String> getAsMap(OAuthConfig config, String endpoint, HttpMethod httpMethod, Map<String, String> params) {
        if (config == null || endpoint == null || httpMethod == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put(OAuthHeader.OAUTH_CONSUMER_KEY.getValue(), config.getConsumerKey());
        authParams.put(OAuthHeader.OAUTH_TIMESTAMP.getValue(), String.valueOf(System.currentTimeMillis() / 1000L));
        authParams.put(OAuthHeader.OAUTH_NONCE.getValue(), UUID.randomUUID().toString());
        authParams.put(OAuthHeader.OAUTH_SIGNATURE_METHOD.getValue(), OAuthSignature.getSignatureMethod().getSignatureMethod());
        authParams.putAll(params);
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            authParams.put(DELETE_PARAM_FORCE, Boolean.TRUE.toString());
        }
        String oAuthSignature = OAuthSignature.generateOAuthSignature(config.getConsumerSecret(), endpoint, httpMethod, authParams);
        authParams.put(OAuthHeader.OAUTH_SIGNATURE.getValue(), oAuthSignature);
        return authParams;
    }

    public static Map<String, String> getAsMap(OAuthConfig config, String endpoint, HttpMethod httpMethod) {
        return OAuthSignature.getAsMap(config, endpoint, httpMethod, Collections.emptyMap());
    }

    public static String getAsQueryString(OAuthConfig config, String endpoint, HttpMethod httpMethod, Map<String, String> params) {
        if (config == null || endpoint == null || httpMethod == null) {
            return "";
        }
        Map<String, String> oauthParameters = OAuthSignature.getAsMap(config, endpoint, httpMethod, params);
        String encodedSignature = oauthParameters.get(OAuthHeader.OAUTH_SIGNATURE.getValue()).replace(SpecialSymbol.PLUS.getPlain(), SpecialSymbol.PLUS.getEncoded());
        oauthParameters.put(OAuthHeader.OAUTH_SIGNATURE.getValue(), encodedSignature);
        return OAuthSignature.mapToString(oauthParameters, SpecialSymbol.EQUAL.getPlain(), SpecialSymbol.AMP.getPlain());
    }

    public static String getAsQueryString(OAuthConfig config, String endpoint, HttpMethod httpMethod) {
        return OAuthSignature.getAsQueryString(config, endpoint, httpMethod, Collections.emptyMap());
    }

    private static String generateOAuthSignature(String customerSecret, String endpoint, HttpMethod httpMethod, Map<String, String> parameters) {
        String signatureBaseString = OAuthSignature.getSignatureBaseString(endpoint, httpMethod.name(), parameters);
        String secret = customerSecret + SpecialSymbol.AMP.getPlain();
        return OAuthSignature.signBaseString(secret, signatureBaseString);
    }

    private static String signBaseString(String secret, String signatureBaseString) {
        try {
            Mac macInstance = Mac.getInstance(OAuthSignature.getSignatureMethod().getAlgorithmType());
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), OAuthSignature.getSignatureMethod().getAlgorithmType());
            macInstance.init(secretKey);
            return Base64.encodeBase64String((byte[])macInstance.doFinal(signatureBaseString.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static SignatureAlgorithm getSignatureMethod() {
        return SignatureMethodType.HMAC_SHA256.getValue();
    }

    private static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private static String getSignatureBaseString(String url, String method, Map<String, String> parameters) {
        String requestURL = OAuthSignature.urlEncode(url);
        Map<String, String> encodedParameters = OAuthSignature.percentEncodeParameters(parameters);
        encodedParameters = OAuthSignature.getSortedParameters(encodedParameters);
        String paramsString = OAuthSignature.mapToString(encodedParameters, SpecialSymbol.EQUAL.getEncoded(), SpecialSymbol.AMP.getEncoded());
        return String.format(BASE_SIGNATURE_FORMAT, method, requestURL, paramsString);
    }

    private static String mapToString(Map<String, String> paramsMap, String keyValueDelimiter, String paramsDelimiter) {
        return paramsMap.entrySet().stream().map(entry -> (String)entry.getKey() + keyValueDelimiter + (String)entry.getValue()).collect(Collectors.joining(paramsDelimiter));
    }

    private static Map<String, String> percentEncodeParameters(Map<String, String> parameters) {
        HashMap<String, String> encodedParamsMap = new HashMap<String, String>();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String key = parameter.getKey();
            String value = parameter.getValue();
            encodedParamsMap.put(OAuthSignature.percentEncode(key), OAuthSignature.percentEncode(value));
        }
        return encodedParamsMap;
    }

    private static String percentEncode(String s) {
        return OAuthSignature.replacePlainByEncoded(URLEncoder.encode(s, StandardCharsets.UTF_8));
    }

    private static String replacePlainByEncoded(String s) {
        ArrayList<SpecialSymbol> symbols = new ArrayList<SpecialSymbol>();
        symbols.add(SpecialSymbol.AMP);
        symbols.add(SpecialSymbol.EQUAL);
        symbols.add(SpecialSymbol.PLUS);
        symbols.add(SpecialSymbol.STAR);
        symbols.add(SpecialSymbol.TILDE);
        for (SpecialSymbol symbol : symbols) {
            s = s.replace(symbol.getPlain(), symbol.getEncoded());
        }
        return s;
    }

    private static Map<String, String> getSortedParameters(Map<String, String> parameters) {
        return new TreeMap<String, String>(parameters);
    }
}

