/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.details;

import com.namasoft.common.Pair;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.InvItemRefEncoder;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.ObjectCreator;
import com.namasoft.modules.commonbasic.contracts.invoicing.IDTOInvoiceLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.supplychain.contracts.details.GeneratedDTOSalesLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class DTOSalesLine
extends GeneratedDTOSalesLine
implements Serializable,
IDTOInvoiceLine {
    public static <T extends DTOSalesLine> DTOSalesLine createNewDetailLine(String id, ObjectCreator<T> creator) {
        DTOSalesLine salesLine = (DTOSalesLine)creator.create();
        salesLine.setId(id);
        salesLine.updateNulls();
        return salesLine;
    }

    @Override
    public void updateNulls() {
        super.updateNulls();
        this.setAddedFreeInvoiceValue(NaMaMath.zeroIfNull((BigDecimal)this.getAddedFreeInvoiceValue()));
        this.setAddedFreeLineValue(NaMaMath.zeroIfNull((BigDecimal)this.getAddedFreeLineValue()));
    }

    @Override
    public BigDecimal unitQuantity() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getQuantity())) {
            return BigDecimal.ZERO;
        }
        this.getQuantity().updateNulls();
        BigDecimal actualQty = this.getPricingQty();
        if (ObjectChecker.isEmptyOrZero((BigDecimal)actualQty)) {
            actualQty = ObjectChecker.toZeroIfNull((BigDecimal)this.getQuantity().getQuantity().getPrimeQty().getValue());
        }
        if (ObjectChecker.isTrue((Boolean)this.getFreeLine()) || ObjectChecker.isNotEmptyOrNull((Object)this.getMasterRowId())) {
            return actualQty;
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.getItem()) || ObjectChecker.isEmptyOrNull((Object)this.getItem().getItem()) || ObjectChecker.isEmptyOrNull((Object)this.getQuantity().getQuantity().getPrimeQty().getUom())) {
            return actualQty;
        }
        Pair minSalesQty = InvItemRefEncoder.minItemSalesQty((EntityReferenceData)this.getItem().getItem(), (String)this.getQuantity().getQuantity().getPrimeQty().getUom().getId());
        if (ObjectChecker.isEmptyOrZero((BigDecimal)((BigDecimal)minSalesQty.getX()))) {
            return actualQty;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)((Boolean)minSalesQty.getY()))) {
            if (InvItemRefEncoder.minSalesQtyIsPerCount((EntityReferenceData)this.getItem().getItem()) && ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getQuantity().getMeasureQty())) {
                actualQty = NaMaMath.divide((BigDecimal)actualQty, (BigDecimal)this.getQuantity().getMeasureQty(), (Integer)15);
                actualQty = this.calcMinQtyWithoutMultiples(actualQty, (Pair<BigDecimal, Boolean>)minSalesQty);
                return actualQty.multiply(this.getQuantity().getMeasureQty());
            }
            return this.calcMinQtyWithoutMultiples(actualQty, (Pair<BigDecimal, Boolean>)minSalesQty);
        }
        if (InvItemRefEncoder.minSalesQtyIsPerCount((EntityReferenceData)this.getItem().getItem()) && ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getQuantity().getMeasureQty())) {
            actualQty = NaMaMath.divide((BigDecimal)actualQty, (BigDecimal)this.getQuantity().getMeasureQty(), (Integer)15);
            actualQty = this.calcMinQtyByMultiples(actualQty, (Pair<BigDecimal, Boolean>)minSalesQty);
            return actualQty.multiply(this.getQuantity().getMeasureQty());
        }
        return this.calcMinQtyByMultiples(actualQty, (Pair<BigDecimal, Boolean>)minSalesQty);
    }

    private BigDecimal calcMinQtyWithoutMultiples(BigDecimal actualQty, Pair<BigDecimal, Boolean> minSalesQty) {
        if (actualQty.compareTo((BigDecimal)minSalesQty.getX()) < 0) {
            return (BigDecimal)minSalesQty.getX();
        }
        return actualQty;
    }

    private BigDecimal calcMinQtyByMultiples(BigDecimal actualQty, Pair<BigDecimal, Boolean> minSalesQty) {
        BigDecimal remainder = NaMaMath.remainder((BigDecimal)actualQty, (BigDecimal)((BigDecimal)minSalesQty.getX()));
        if (ObjectChecker.isEmptyOrZero((BigDecimal)remainder)) {
            return actualQty;
        }
        return actualQty.subtract(remainder).add((BigDecimal)minSalesQty.getX());
    }

    public void updateDiscountByLocation(String discLocation, BigDecimal newDiscountPercentage) {
        if (ObjectChecker.isEmptyOrNull((Object)discLocation)) {
            return;
        }
        DTOMoneyEffectDetails effectByLocation = this.getPrice().fetchDiscountEffect(DiscountLocation.valueOf((String)discLocation));
        if (effectByLocation == null) {
            return;
        }
        BigDecimal currentDiscountPercent = ObjectChecker.toZeroIfNull((BigDecimal)effectByLocation.getPercentage());
        effectByLocation.setPercentage(currentDiscountPercent.add(newDiscountPercentage));
    }
}

