/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.valueobjects;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.modules.commonbasic.contracts.requests.inv.DTOMeasures;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.GeneratedDTOUserQuantity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOUserQuantity
extends GeneratedDTOUserQuantity
implements Serializable {
    public DTOUserQuantity updateNulls() {
        if (this.getBaseQty() == null) {
            this.setBaseQty(new DTORawQuantity());
        }
        if (this.getQuantity() == null) {
            this.setQuantity(new DTOQuantity());
        }
        if (this.getQuantity().getPrimeQty() == null) {
            this.getQuantity().setPrimeQty(new DTORawQuantity());
        }
        if (this.getQuantity().getSecondQty() == null) {
            this.getQuantity().setSecondQty(new DTORawQuantity());
        }
        if (this.getMeasures() == null) {
            this.setMeasures(new DTOMeasures());
        }
        return this;
    }

    public static DTOUserQuantity empty() {
        DTOUserQuantity q = new DTOUserQuantity();
        q.updateNulls();
        return q;
    }

    public DTOUserQuantity cloneData() {
        DTOUserQuantity quantity = DTOUserQuantity.empty();
        this.updateNulls();
        quantity.getBaseQty().setUom(this.getBaseQty().getUom());
        quantity.getBaseQty().setValue(this.getBaseQty().getValue());
        this.getQuantity().getPrimeQty().setUom(this.getQuantity().getPrimeQty().getUom());
        this.getQuantity().getPrimeQty().setValue(this.getQuantity().getPrimeQty().getValue());
        this.getQuantity().getSecondQty().setUom(this.getQuantity().getSecondQty().getUom());
        this.getQuantity().getSecondQty().setValue(this.getQuantity().getSecondQty().getValue());
        this.setMeasures(this.getMeasures());
        return quantity;
    }

    public BigDecimal primeQtyValue() {
        if (this.getQuantity() == null) {
            return BigDecimal.ZERO;
        }
        if (this.getQuantity().getPrimeQty() == null) {
            return BigDecimal.ZERO;
        }
        return this.getQuantity().getPrimeQty().getValue();
    }

    public void updateMeasureQty(BigDecimal measuresFactor) {
        if (this.getMeasures() == null) {
            return;
        }
        BigDecimal length = NaMaMath.oneIfEmptyOrZero((BigDecimal)this.getMeasures().getLength());
        BigDecimal height = NaMaMath.oneIfEmptyOrZero((BigDecimal)this.getMeasures().getHeight());
        BigDecimal width = NaMaMath.oneIfEmptyOrZero((BigDecimal)this.getMeasures().getWidth());
        this.setMeasureQty(NaMaMath.divide((BigDecimal)this.primeQtyValue(), (BigDecimal)length.multiply(height).multiply(width).multiply(measuresFactor), (Integer)2));
    }
}

