/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue;

import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.delivery_queue.screens.ScreenWithMenuBar;
import com.namasoft.delivery_queue.utils.DeliveryGeneralSettings;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import javafx.application.Application;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication(scanBasePackages={"com.namasoft.delivery_queue"})
public class DeliveryQueueEntryPoint
extends Application {
    private static Stage stage;

    public void start(Stage primaryStage) throws Exception {
        this.doSetUp();
        stage = primaryStage;
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        Scene scene = new Scene((Parent)new ScreenWithMenuBar(), screenBounds.getWidth(), screenBounds.getHeight());
        scene.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Delivery Order Queue");
        primaryStage.setMaximized(true);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/main.css").toExternalForm());
        primaryStage.show();
        primaryStage.setOnCloseRequest(e -> this.closeApp());
    }

    private void doSetUp() {
        DeliveryGeneralSettings.loadSettings();
        LoggingConfigurator.configureUsingCode((boolean)false);
        DeliveryQueueUtils.init();
    }

    private void closeApp() {
        DeliveryQueueUtils.changeInProgressOrdersToNotDelivered();
        System.exit(0);
    }

    public static void showPopup(String message) {
        Popup popup = new Popup();
        popup.setAutoFix(true);
        popup.setAutoHide(true);
        popup.setHideOnEscape(true);
        Label label = new Label(message);
        label.setOnMouseReleased(e -> popup.hide());
        label.getStyleClass().add((Object)"popup");
        popup.getContent().add((Object)label);
        popup.setOnShown(e -> {
            popup.setX(stage.getX() + stage.getWidth() / 2.0 - popup.getWidth() / 2.0);
            popup.setY(stage.getY() + stage.getHeight() / 2.0 - popup.getHeight() / 2.0);
        });
        if (stage != null) {
            popup.show((Window)stage);
        }
    }
}

