/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.screens.CurrentOrdersScreen;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.screens.StyledButton;
import com.namasoft.delivery_queue.screens.StyledText;
import com.namasoft.delivery_queue.utils.DeliveryGeneralSettings;
import com.namasoft.delivery_queue.utils.DeliveryQueueReaderUtil;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import com.namasoft.delivery_queue.utils.INamaClickable;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;

public class CurrentOrderCard
extends StackPane
implements INamaClickable {
    private final DeliveryOrder currentOrder;
    private final StyledText title;
    private final WebView detailsView;
    private final CurrentOrdersScreen parentScreen;

    public static CurrentOrderCard create(CurrentOrdersScreen parentScreen, DeliveryOrder currentOrder) {
        return new CurrentOrderCard(parentScreen, currentOrder);
    }

    private CurrentOrderCard(CurrentOrdersScreen parentScreen, DeliveryOrder currentOrder) {
        this.getStyleClass().add((Object)"card");
        this.parentScreen = parentScreen;
        this.currentOrder = currentOrder;
        this.title = new StyledText();
        this.detailsView = new WebView();
        StyledButton finishAndGetNext = new StyledButton("Finish And Get Next");
        finishAndGetNext.customOnMouseClicked(this.getHomeScreen(), this.createActionFor(e -> this.finishOrderAction(true)));
        StyledButton finish = new StyledButton("Finish");
        finish.customOnMouseClicked(this.getHomeScreen(), this.createActionFor(e -> this.finishOrderAction(false)));
        StyledButton later = new StyledButton("Later");
        later.customOnMouseClicked(this.getHomeScreen(), this.createActionFor(e -> this.postponedCurrentOrder()));
        StyledButton undo = new StyledButton("Undo");
        undo.customOnMouseClicked(this.getHomeScreen(), this.createActionFor(e -> this.undoCurrentOrder()));
        HBox titleBox = new HBox();
        titleBox.getChildren().add((Object)this.title);
        titleBox.setAlignment(Pos.CENTER);
        HBox buttonBox = new HBox(20.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{finishAndGetNext, finish, later, undo});
        buttonBox.setAlignment(Pos.CENTER);
        VBox cardBox = new VBox();
        cardBox.getChildren().addAll((Object[])new Node[]{titleBox, this.detailsView, buttonBox});
        this.getChildren().add((Object)cardBox);
        this.copyMyParentAction((Node)this, (Node)parentScreen);
        this.showCurrentOrderInfo();
        this.getCurrentOrder().setStatus(DeliveryQueueReaderUtil.IN_PROGRESS);
        this.draw();
        parentScreen.getChildren().add((Object)this);
        DeliveryQueueReaderUtil.instance().writeData(Collections.singletonList(currentOrder));
    }

    private Runnable createActionFor(Consumer<CurrentOrderCard> consumer) {
        return () -> consumer.accept(this);
    }

    public void draw() {
        this.setPrefHeight(DeliveryGeneralSettings.getDetailsHeight());
        this.showCurrentOrderInfo();
    }

    private void copyMyParentAction(Node child, Node parent) {
        if (parent == null) {
            return;
        }
        if (ObjectChecker.areEqual((Object)child, (Object)this.detailsView)) {
            child.setOnScroll(this::scrollDetailsView);
            return;
        }
        child.setOnScroll(parent.getOnScroll());
        if (!(child instanceof Pane)) {
            return;
        }
        for (Node node : ((Pane)child).getChildren()) {
            this.copyMyParentAction(node, child);
        }
    }

    private void scrollDetailsView(ScrollEvent e) {
        if (e.getDeltaY() == 0.0) {
            return;
        }
        Platform.runLater(() -> {
            ScrollBar bar = this.getVScrollBar(this.detailsView);
            if (bar == null) {
                this.getParentScreen().scrollMe(e);
                return;
            }
            if (this.shouldScrollParent(bar, e)) {
                this.getParentScreen().scrollMe(e);
            }
        });
    }

    private ScrollBar getVScrollBar(WebView webView) {
        Set scrolls = webView.lookupAll(".scroll-bar");
        for (Node scrollNode : scrolls) {
            ScrollBar scroll;
            if (!(scrollNode instanceof ScrollBar) || (scroll = (ScrollBar)scrollNode).getOrientation() != Orientation.VERTICAL) continue;
            return scroll;
        }
        return null;
    }

    private boolean shouldScrollParent(ScrollBar bar, ScrollEvent e) {
        if (bar == null) {
            return true;
        }
        Integer scrollTop = (Integer)this.detailsView.getEngine().executeScript("document.body.scrollTop");
        Integer offsetHeight = (Integer)this.detailsView.getEngine().executeScript("document.documentElement.offsetHeight");
        Integer clientHeight = (Integer)this.detailsView.getEngine().executeScript("document.body.clientHeight");
        return ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{scrollTop + clientHeight >= offsetHeight && e.getDeltaY() < 0.0, scrollTop <= 0 && e.getDeltaY() >= 0.0});
    }

    private void finishOrderAction(boolean serveNext) {
        if (serveNext) {
            this.getHomeScreen().serveOrder(0);
        }
        this.currentOrder.setStatus(DeliveryQueueReaderUtil.DELIVERED);
        this.currentOrder.setDeliveryOrderDate(new Date());
        DeliveryQueueUtils.markCurrentOrderAsServed(this.currentOrder);
    }

    private void postponedCurrentOrder() {
        this.getHomeScreen().postponedOrder(this.currentOrder);
    }

    private void undoCurrentOrder() {
        this.currentOrder.setStatus(DeliveryQueueReaderUtil.NOT_DELIVERED);
        DeliveryQueueUtils.undoOrder(this.currentOrder);
    }

    public void showCurrentOrderInfo() {
        if (this.currentOrder == null) {
            return;
        }
        String page = "<style type='text/css'>body{color : " + DeliveryGeneralSettings.getDetailsFontColor() + ";}</style>";
        page = page + "<body >" + this.currentOrder.getDetails() + "</body>";
        this.detailsView.getEngine().loadContent(page);
        this.title.setText(this.currentOrder.getSummary());
    }

    public DeliveryOrder getCurrentOrder() {
        return this.currentOrder;
    }

    public CurrentOrdersScreen getParentScreen() {
        return this.parentScreen;
    }

    public HomeScreen getHomeScreen() {
        return this.getParentScreen().getHomeScreen();
    }

    @Override
    public void clickHandler(EventHandler<? extends Event> handler) {
        this.setOnMouseClicked(handler);
    }
}

