/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.screens.CurrentOrderCard;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.VBox;

public class CurrentOrdersScreen
extends VBox {
    private final HomeScreen parentScreen;
    private final ScrollPane container;

    public static CurrentOrdersScreen create(HomeScreen parentScreen, ScrollPane container) {
        return new CurrentOrdersScreen(parentScreen, container);
    }

    private CurrentOrdersScreen(HomeScreen parentScreen, ScrollPane container) {
        this.parentScreen = parentScreen;
        this.container = container;
        this.setSpacing(10.0);
        this.setOnScroll(this::scrollMe);
        this.draw();
    }

    public void scrollMe(ScrollEvent e) {
        double delta = 15.0 * this.container.getVmax() / this.container.getHeight();
        if (e.getDeltaY() > 0.0) {
            delta *= -1.0;
        }
        if (this.container.getVmax() >= this.container.getVvalue() && this.container.getVmin() <= this.container.getVvalue()) {
            this.container.setVvalue(this.container.getVvalue() + delta);
        }
    }

    public void draw() {
        ArrayList<CurrentOrderCard> cards = new ArrayList<CurrentOrderCard>();
        for (DeliveryOrder order : DeliveryQueueUtils.getInProgressOrderList()) {
            cards.add(CurrentOrderCard.create(this, order));
        }
        this.updateChildren(cards);
    }

    private void updateChildren(List<CurrentOrderCard> cards) {
        this.getChildren().clear();
        for (CurrentOrderCard card : cards) {
            this.getChildren().add((Object)card);
        }
    }

    public HomeScreen getParentScreen() {
        return this.parentScreen;
    }

    public HomeScreen getHomeScreen() {
        return this.getParentScreen();
    }
}

