/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.screens.QueueScreen;
import com.namasoft.delivery_queue.screens.StyledText;
import com.namasoft.delivery_queue.utils.DeliveryGeneralSettings;
import com.namasoft.delivery_queue.utils.INamaClickable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.layout.StackPane;

public class DeliveryQueueOrderCard
extends StackPane
implements INamaClickable {
    private final DeliveryOrder item;
    private final StyledText summary;
    private int index;
    private final QueueScreen parentScreen;

    public static DeliveryQueueOrderCard create(QueueScreen parentScreen, int index, DeliveryOrder item) {
        return new DeliveryQueueOrderCard(parentScreen, index, item);
    }

    private DeliveryQueueOrderCard(QueueScreen parentScreen, int index, DeliveryOrder item) {
        this.getStyleClass().add((Object)"card");
        this.item = item;
        this.index = index;
        this.parentScreen = parentScreen;
        this.summary = new StyledText(item.getSummary());
        this.getChildren().add((Object)this.summary);
        this.draw();
        this.customOnMouseClicked(this.getHomeScreen(), () -> this.getHomeScreen().serveOrder(this.getIndex()));
    }

    public DeliveryOrder getItem() {
        return this.item;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void draw() {
        this.getChildren().clear();
        this.summary.setStyle(this.summaryStyle());
        this.getChildren().add((Object)this.summary);
    }

    private String summaryStyle() {
        StringBuilder builder = new StringBuilder("-fx-font-size: ").append(DeliveryGeneralSettings.getSummaryFontSize()).append("px;");
        return builder.append("-fx-fill: ").append(DeliveryGeneralSettings.getSummaryFontColor()).append(";").toString();
    }

    public QueueScreen getParentScreen() {
        return this.parentScreen;
    }

    public HomeScreen getHomeScreen() {
        return this.getParentScreen().getHomeScreen();
    }

    @Override
    public void clickHandler(EventHandler<? extends Event> handler) {
        this.setOnMouseClicked(handler);
    }
}

