/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.delivery_queue.screens.DeliveryQueueOrderCard;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.screens.QueueScreen;
import com.namasoft.delivery_queue.utils.DeliveryPageInfo;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;

public class DeliveryQueueTab
extends Tab {
    private final String key;
    private final HomeScreen parentScreen;

    public static DeliveryQueueTab create(HomeScreen parentScreen, String key) {
        return new DeliveryQueueTab(parentScreen, key);
    }

    private DeliveryQueueTab(HomeScreen parentScreen, String key) {
        super(key);
        this.key = key;
        this.parentScreen = parentScreen;
        this.setContent((Node)QueueScreen.create(this));
        this.updateView();
    }

    public VBox getQueueScreenList() {
        return this.getQueueScreen().getList();
    }

    public QueueScreen getQueueScreen() {
        return (QueueScreen)this.getContent();
    }

    public String getKey() {
        return this.key;
    }

    public void addChild(DeliveryQueueOrderCard card) {
        this.getQueueScreenList().getChildren().add((Object)card);
    }

    public HomeScreen getParentScreen() {
        return this.parentScreen;
    }

    public HomeScreen getHomeScreen() {
        return this.getParentScreen();
    }

    public void updateView() {
        this.updateView(DeliveryQueueUtils.getPageInfo(this.getKey()));
    }

    public void updateView(DeliveryPageInfo info) {
        this.getQueueScreenList().getChildren().clear();
        for (int i = 0; i < info.getOrders().size(); ++i) {
            this.addChild(DeliveryQueueOrderCard.create(this.getQueueScreen(), i, info.getOrders().get(i)));
        }
    }

    public void filterView(KeyEvent text) {
        if (ObjectChecker.isEmptyOrNull((Object)text)) {
            return;
        }
        DeliveryPageInfo info = DeliveryQueueUtils.getPageInfo(this.getKey());
        DeliveryPageInfo newInfo = new DeliveryPageInfo();
        newInfo.setCurrentPage(info.getCurrentPage());
        newInfo.setTotalRecords(info.getTotalRecords());
        newInfo.setPageSize(info.getPageSize());
        newInfo.setOrders(info.getOrders().stream().filter(o -> o.getSummary().toLowerCase().contains(this.textOf(text.getSource()).toLowerCase())).collect(Collectors.toList()));
        this.updateView(newInfo);
    }

    private String textOf(Object source) {
        if (source instanceof TextField) {
            return ((TextField)source).getText();
        }
        return "";
    }
}

