/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.screens.CurrentOrderCard;
import com.namasoft.delivery_queue.screens.CurrentOrdersScreen;
import com.namasoft.delivery_queue.screens.DeliveryQueueTab;
import com.namasoft.delivery_queue.screens.DeliveryQueueTabPane;
import com.namasoft.delivery_queue.screens.IReplaceable;
import com.namasoft.delivery_queue.screens.ScreenWithMenuBar;
import com.namasoft.delivery_queue.screens.StyledButton;
import com.namasoft.delivery_queue.utils.DeliveryQueueReaderUtil;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import com.namasoft.delivery_queue.utils.IListenerScreen;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class HomeScreen
extends StackPane
implements IReplaceable,
IListenerScreen {
    private final DeliveryQueueTabPane tabPane = new DeliveryQueueTabPane();
    private final DeliveryQueueTab postponedTab;
    private final DeliveryQueueTab todayTab;
    private final CurrentOrdersScreen servingList;
    private final StackPane loadingIndicator = new StackPane();

    public static HomeScreen create() {
        return new HomeScreen();
    }

    private HomeScreen() {
        ProgressIndicator indicator = new ProgressIndicator();
        indicator.setMaxWidth(50.0);
        indicator.setMaxHeight(50.0);
        this.loadingIndicator.getChildren().add((Object)indicator);
        SplitPane split = new SplitPane();
        DeliveryQueueUtils.listen(this);
        ScrollPane scrollPane = new ScrollPane();
        this.servingList = CurrentOrdersScreen.create(this, scrollPane);
        scrollPane.setContent((Node)this.servingList);
        scrollPane.setFitToWidth(true);
        BorderPane border = new BorderPane((Node)scrollPane);
        StyledButton nextOrder = new StyledButton("Next Order");
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER);
        box.getChildren().add((Object)nextOrder);
        border.setBottom((Node)box);
        nextOrder.customOnMouseClicked(this, () -> this.serveOrder(0));
        this.todayTab = DeliveryQueueTab.create(this, DeliveryQueueReaderUtil.TODAY_QUEUE);
        this.todayTab.setClosable(false);
        this.postponedTab = DeliveryQueueTab.create(this, DeliveryQueueReaderUtil.POSTPONED_QUEUE);
        this.postponedTab.setClosable(false);
        this.tabPane.getTabs().addAll((Object[])new Tab[]{this.todayTab, this.postponedTab});
        split.getItems().addAll((Object[])new Node[]{this.tabPane, border});
        this.getChildren().add((Object)split);
    }

    public DeliveryQueueTab getSelectedTab() {
        return this.tabPane.getSelectedQueueTab();
    }

    public void postponedOrder(DeliveryOrder currentOrder) {
        currentOrder.setStatus(DeliveryQueueReaderUtil.NOT_DELIVERED);
        currentOrder.setPostponed(true);
        DeliveryQueueUtils.postponedOrder(this.postponedTab.getKey(), currentOrder);
    }

    public void serveOrder(int index) {
        DeliveryOrder order = this.getSelectedTab().getQueueScreen().removeCard(index);
        DeliveryOrder currentOrder = DeliveryQueueUtils.serveNextOrder(order, this.getSelectedTab().getKey());
        if (currentOrder == null) {
            return;
        }
        currentOrder.setFromTab(this.getSelectedTab().getKey());
        CurrentOrderCard.create(this.servingList, currentOrder);
    }

    @Override
    public String getMenuItemKey() {
        return ScreenWithMenuBar.HOME_SCREEN;
    }

    @Override
    public void updateView() {
        this.servingList.draw();
        this.todayTab.updateView();
        this.postponedTab.updateView();
    }

    @Override
    public void showLoadingIndicator() {
        this.getChildren().add((Object)this.loadingIndicator);
    }

    @Override
    public void hideLoadingIndicator() {
        this.getChildren().remove((Object)this.loadingIndicator);
    }
}

