/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.delivery_queue.DeliveryQueueEntryPoint;
import com.namasoft.delivery_queue.screens.IReplaceable;
import com.namasoft.delivery_queue.screens.ScreenWithMenuBar;
import com.namasoft.delivery_queue.screens.SearchBox;
import com.namasoft.delivery_queue.screens.StyledButton;
import com.namasoft.delivery_queue.screens.StyledText;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class MasterPinScreen
extends BorderPane
implements IReplaceable {
    private final StyledText masterPinText;
    private final PasswordField masterPinValue;
    private final StyledButton confirm;
    private final StyledButton back;
    private final StackPane centerPane = new StackPane();
    private final StackPane loadingIndicator = new StackPane();
    private final ScreenWithMenuBar parentScreen;
    private final int maxCols = 1;
    private int currentCol = -1;
    private int currentRow = 0;

    public static MasterPinScreen create(ScreenWithMenuBar parentScreen) {
        return new MasterPinScreen(parentScreen);
    }

    private MasterPinScreen(ScreenWithMenuBar parentScreen) {
        this.parentScreen = parentScreen;
        ProgressIndicator indicator = new ProgressIndicator();
        indicator.setMaxWidth(50.0);
        indicator.setMaxHeight(50.0);
        this.loadingIndicator.getChildren().add((Object)indicator);
        this.masterPinText = new StyledText("Please Enter Master Pin");
        this.masterPinValue = new PasswordField();
        this.confirm = new StyledButton("Confirm");
        this.confirm.customOnMouseClicked(this, this::confirm);
        this.back = new StyledButton("Back");
        this.back.customOnMouseClicked(this, this::goToHome);
        this.getChildren().add((Object)new SearchBox());
        this.draw();
    }

    private void confirm() {
        String text = this.masterPinValue.getText();
        if (ObjectChecker.isEmptyOrNull((Object)text)) {
            DeliveryQueueEntryPoint.showPopup("Master Pin is Empty");
            return;
        }
        this.masterPinValue.setText("");
        if (DeliveryQueueUtils.login(text)) {
            this.parentScreen.goToSettings();
        }
    }

    private void goToHome() {
        this.masterPinValue.setText("");
        this.parentScreen.goToHome();
    }

    private void draw() {
        this.getChildren().clear();
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(20.0);
        grid.setVgap(20.0);
        grid.add((Node)this.masterPinText, this.calcCols(), this.currentRow);
        grid.add((Node)this.masterPinValue, this.calcCols(), this.currentRow);
        grid.add((Node)this.confirm, this.calcCols(), this.currentRow);
        GridPane.setColumnSpan((Node)this.confirm, (Integer)1);
        GridPane.setHalignment((Node)this.confirm, (HPos)HPos.CENTER);
        grid.add((Node)this.back, this.calcCols(), this.currentRow);
        GridPane.setColumnSpan((Node)this.back, (Integer)1);
        GridPane.setHalignment((Node)this.back, (HPos)HPos.CENTER);
        this.centerPane.getChildren().add((Object)grid);
        this.setCenter((Node)this.centerPane);
    }

    private int calcCols() {
        ++this.currentCol;
        if (this.currentCol == 1) {
            ++this.currentRow;
            this.currentCol = 0;
        }
        return this.currentCol;
    }

    @Override
    public String getMenuItemKey() {
        return ScreenWithMenuBar.MASTER_PIN_SCREEN;
    }

    @Override
    public void showLoadingIndicator() {
        this.centerPane.getChildren().add((Object)this.loadingIndicator);
    }

    @Override
    public void hideLoadingIndicator() {
        this.centerPane.getChildren().remove((Object)this.loadingIndicator);
    }
}

