/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.delivery_queue.screens.DeliveryQueueTab;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.screens.StyledButton;
import com.namasoft.delivery_queue.screens.StyledText;
import com.namasoft.delivery_queue.utils.DeliveryPageInfo;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import com.namasoft.delivery_queue.utils.IListenerScreen;
import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class NamaPagination
extends StackPane
implements IListenerScreen {
    private final int maxPageIndicatorCount;
    private int currentPageIndex;
    private int pageCount;
    private int pageSize;
    private long totalRecordsCount;
    private final double iconSize;
    private final HBox pageIndicators;
    private final StyledButton refreshBtn;
    private final StyledButton firstPageBtn;
    private final StyledButton previousPageBtn;
    private final StyledButton nextPageBtn;
    private final StyledButton lastPageBtn;
    private final StyledText fromPageTo;
    private final DeliveryQueueTab parentTab;

    public static NamaPagination create(DeliveryQueueTab parentTab) {
        return new NamaPagination(parentTab);
    }

    private NamaPagination(DeliveryQueueTab parentTab) {
        this.parentTab = parentTab;
        DeliveryQueueUtils.listen(this);
        this.pageCount = 1;
        this.currentPageIndex = 0;
        this.maxPageIndicatorCount = 3;
        this.pageIndicators = new HBox(2.0);
        this.iconSize = 40.0;
        this.fromPageTo = new StyledText(this.pageStatistics());
        VBox indicatorBox = new VBox();
        indicatorBox.getChildren().add((Object)this.pageIndicators);
        indicatorBox.setAlignment(Pos.CENTER);
        this.refreshBtn = new StyledButton("", this.createIcon("icons/refresh.png"));
        this.firstPageBtn = new StyledButton("", this.createIcon("icons/first.png"));
        this.previousPageBtn = new StyledButton("", this.createIcon("icons/previous.png"));
        this.nextPageBtn = new StyledButton("", this.createIcon("icons/next.png"));
        this.lastPageBtn = new StyledButton("", this.createIcon("icons/last.png"));
        this.setUpActions();
        HBox box = new HBox(5.0);
        this.buildPagesIndicator();
        box.getChildren().addAll((Object[])new Node[]{this.refreshBtn, this.firstPageBtn, this.previousPageBtn, indicatorBox, this.nextPageBtn, this.lastPageBtn, this.fromPageTo});
        box.setAlignment(Pos.CENTER);
        VBox vBox = new VBox(new Node[]{box});
        vBox.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)vBox);
    }

    private void setUpActions() {
        this.refreshBtn.customOnMouseClicked(this.getHomeScreen(), this.handleClick(e -> this.moveToPage(this.currentPageIndex)));
        this.firstPageBtn.customOnMouseClicked(this.getHomeScreen(), this.handleClick(e -> this.moveToPage(0)));
        this.lastPageBtn.customOnMouseClicked(this.getHomeScreen(), this.handleClick(NamaPagination::moveToLastPage));
        this.nextPageBtn.customOnMouseClicked(this.getHomeScreen(), this.handleClick(NamaPagination::moveToNextPage));
        this.previousPageBtn.customOnMouseClicked(this.getHomeScreen(), this.handleClick(NamaPagination::moveToPreviousPage));
    }

    private Runnable handleClick(Consumer<NamaPagination> consumer) {
        return () -> consumer.accept(this);
    }

    private String pageStatistics() {
        String from = ServerStringUtils.leftPad((Long)Math.min((long)(this.currentPageIndex * this.pageSize + 1), this.totalRecordsCount), (Integer)("" + this.totalRecordsCount).length());
        String to = ServerStringUtils.leftPad((Long)Math.min((long)((this.currentPageIndex + 1) * this.pageSize), this.totalRecordsCount), (Integer)("" + this.totalRecordsCount).length());
        return from + " : " + to + " of " + this.totalRecordsCount + " Record";
    }

    private ImageView createIcon(String url) {
        ImageView view = new ImageView(url);
        view.setFitWidth(this.iconSize);
        view.setFitHeight(this.iconSize);
        return view;
    }

    private void buildPagesIndicator() {
        int firstIndicator;
        this.pageIndicators.getChildren().clear();
        for (int i = firstIndicator = this.currentPageIndex == 0 ? this.currentPageIndex : (this.currentPageIndex == this.pageCount - 1 ? this.currentPageIndex - 2 : this.currentPageIndex - 1); i < firstIndicator + this.maxPageIndicatorCount && i < this.pageCount; ++i) {
            StackPane pane = new StackPane();
            Rectangle rectangle = new Rectangle(this.iconSize + 2.0, this.iconSize + 2.0);
            rectangle.setFill((Paint)Color.WHITE);
            rectangle.setArcHeight(10.0);
            rectangle.setArcWidth(10.0);
            rectangle.setStrokeWidth(2.0);
            rectangle.setStroke((Paint)Color.BLACK);
            pane.getChildren().add((Object)rectangle);
            Text text = new Text();
            pane.getChildren().add((Object)text);
            text.setTextAlignment(TextAlignment.CENTER);
            text.setFont(Font.font((double)this.iconSize));
            if (i >= 0) {
                text.setText("" + (i + 1));
            }
            if (ObjectChecker.areEqual((Object)this.currentPageIndex, (Object)i)) {
                text.setFill((Paint)Color.BLUE);
            }
            text.setOnMouseClicked(this.pageClickHandler(i));
            rectangle.setOnMouseClicked(text.getOnMouseClicked());
            pane.setOnMouseClicked(text.getOnMouseClicked());
            this.pageIndicators.getChildren().add((Object)pane);
        }
    }

    private EventHandler<MouseEvent> pageClickHandler(int selectedPage) {
        return e -> {
            this.getHomeScreen().showLoadingIndicator();
            this.moveToPage(selectedPage);
            this.getHomeScreen().hideLoadingIndicator();
        };
    }

    private void moveToPage(int selectedPage) {
        DeliveryQueueUtils.moveToPage(this.parentTab.getKey(), selectedPage);
        this.currentPageIndex = selectedPage;
    }

    private void moveToPreviousPage() {
        if (this.currentPageIndex < 1) {
            return;
        }
        this.moveToPage(this.currentPageIndex - 1);
    }

    private void moveToNextPage() {
        if (this.currentPageIndex >= this.pageCount) {
            return;
        }
        this.moveToPage(this.currentPageIndex + 1);
    }

    private void moveToLastPage() {
        this.moveToPage(this.pageCount);
    }

    @Override
    public void updateView() {
        DeliveryPageInfo info = DeliveryQueueUtils.getCurrentTabInfo(this.parentTab.getKey());
        this.currentPageIndex = info.getCurrentPage();
        this.pageSize = Math.max(info.getPageSize(), 1);
        this.totalRecordsCount = info.getTotalRecords();
        this.pageCount = Math.max((int)((this.totalRecordsCount + (long)this.pageSize - 1L) / (long)this.pageSize), 1);
        this.buildPagesIndicator();
        this.fromPageTo.setText(this.pageStatistics());
    }

    public HomeScreen getHomeScreen() {
        return this.parentTab.getHomeScreen();
    }
}

