/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.screens.DeliveryQueueOrderCard;
import com.namasoft.delivery_queue.screens.DeliveryQueueTab;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.screens.NamaPagination;
import com.namasoft.delivery_queue.screens.SearchBox;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class QueueScreen
extends BorderPane {
    private final DeliveryQueueTab parentScreen;
    private final VBox box = new VBox(20.0);

    public static QueueScreen create(DeliveryQueueTab parentScreen) {
        return new QueueScreen(parentScreen, NamaPagination.create(parentScreen));
    }

    private QueueScreen(DeliveryQueueTab parentScreen, NamaPagination pagination) {
        ScrollPane scroll = new ScrollPane((Node)this.box);
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        this.setCenter((Node)scroll);
        SearchBox searchBox = new SearchBox();
        this.setTop((Node)searchBox);
        searchBox.setOnKeyReleased(parentScreen::filterView);
        this.parentScreen = parentScreen;
        this.setBottom((Node)pagination);
    }

    public DeliveryOrder removeCard(int index) {
        if (ObjectChecker.isEmptyOrNull((Object)this.box.getChildren())) {
            return null;
        }
        if (index < 0 || index >= this.box.getChildren().size()) {
            return null;
        }
        DeliveryOrder item = ((DeliveryQueueOrderCard)this.box.getChildren().remove(index)).getItem();
        for (int i = 0; i < this.box.getChildren().size(); ++i) {
            ((DeliveryQueueOrderCard)this.box.getChildren().get(i)).setIndex(i);
        }
        return item;
    }

    public DeliveryQueueTab getParentScreen() {
        return this.parentScreen;
    }

    public HomeScreen getHomeScreen() {
        return this.getParentScreen().getHomeScreen();
    }

    public VBox getList() {
        return this.box;
    }
}

