/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.delivery_queue.screens.HomeScreen;
import com.namasoft.delivery_queue.screens.IReplaceable;
import com.namasoft.delivery_queue.screens.MasterPinScreen;
import com.namasoft.delivery_queue.screens.SettingsScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ScreenWithMenuBar
extends StackPane {
    public static String HOME_SCREEN = "Home";
    public static String SETTINGS_SCREEN = "Settings";
    public static String MASTER_PIN_SCREEN = "masterPin";
    private final Map<String, IReplaceable> items = new HashMap<String, IReplaceable>();
    private final HBox menuBox;
    private IReplaceable body;
    private final VBox box = new VBox();

    public ScreenWithMenuBar() {
        this.menuBox = new HBox();
        HomeScreen homeScreen = HomeScreen.create();
        this.items.put(HOME_SCREEN, homeScreen);
        this.items.put(SETTINGS_SCREEN, SettingsScreen.create(this));
        this.items.put(MASTER_PIN_SCREEN, MasterPinScreen.create(this));
        this.body = homeScreen;
        MenuItem homeItem = new MenuItem(HOME_SCREEN);
        MenuItem settingsItem = new MenuItem(SETTINGS_SCREEN);
        MenuButton menu = new MenuButton("Menu", null, new MenuItem[]{homeItem, settingsItem});
        this.menuBox.getChildren().add((Object)menu);
        this.box.getChildren().addAll((Object[])new Node[]{this.menuBox, (Node)this.body});
        homeItem.setOnAction(e -> this.changeCurrentScreen(homeItem));
        settingsItem.setOnAction(e -> this.changeCurrentScreen(settingsItem));
        this.getChildren().add((Object)this.box);
        VBox.setVgrow((Node)((Node)this.body), (Priority)Priority.ALWAYS);
    }

    private void changeCurrentScreen(MenuItem item) {
        String itemCode = item.getText();
        if (ObjectChecker.areEqual((Object)itemCode, (Object)this.body.getMenuItemKey())) {
            return;
        }
        this.box.getChildren().clear();
        this.body = this.items.get(itemCode);
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.add(this.menuBox);
        if (ObjectChecker.areEqual((Object)itemCode, (Object)SETTINGS_SCREEN)) {
            widgets.clear();
            this.body = this.items.get(MASTER_PIN_SCREEN);
        }
        widgets.add((Node)this.body);
        VBox.setVgrow((Node)((Node)this.body), (Priority)Priority.ALWAYS);
        this.box.getChildren().addAll(widgets);
    }

    public void goToHome() {
        this.box.getChildren().clear();
        this.body = this.items.get(HOME_SCREEN);
        VBox.setVgrow((Node)((Node)this.body), (Priority)Priority.ALWAYS);
        this.box.getChildren().addAll((Object[])new Node[]{this.menuBox, (Node)this.body});
    }

    public void goToSettings() {
        this.box.getChildren().clear();
        this.body = this.items.get(SETTINGS_SCREEN);
        VBox.setVgrow((Node)((Node)this.body), (Priority)Priority.ALWAYS);
        this.box.getChildren().addAll((Object[])new Node[]{this.menuBox, (Node)this.body});
    }
}

