/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.screens;

import com.namasoft.delivery_queue.screens.IReplaceable;
import com.namasoft.delivery_queue.screens.ScreenWithMenuBar;
import com.namasoft.delivery_queue.screens.SearchBox;
import com.namasoft.delivery_queue.screens.StyledButton;
import com.namasoft.delivery_queue.screens.StyledText;
import com.namasoft.delivery_queue.screens.StyledTextField;
import com.namasoft.delivery_queue.utils.DeliveryGeneralSettings;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class SettingsScreen
extends BorderPane
implements IReplaceable {
    private final CompositeWidget detailsFontColor;
    private final CompositeWidget detailsHeight;
    private final CompositeWidget summaryFontColor;
    private final CompositeWidget summaryFontSize;
    private final CompositeWidget serverUrl;
    private final CompositeWidget serverAccountUserName;
    private final CompositeWidget serverAccountPassword;
    private final CompositeWidget queueCode;
    private final CompositeWidget refreshOrdersEvery;
    private final CompositeWidget queuePageSize;
    private final StyledButton saveSettings;
    private final ScreenWithMenuBar parentScreen;
    private final StackPane centerPane = new StackPane();
    private final StackPane loadingIndicator = new StackPane();
    private final int maxCols = 4;
    private int currentCol = -1;
    private int currentRow = 0;

    public static SettingsScreen create(ScreenWithMenuBar parentScreen) {
        return new SettingsScreen(parentScreen);
    }

    private SettingsScreen(ScreenWithMenuBar parentScreen) {
        ProgressIndicator indicator = new ProgressIndicator();
        indicator.setMaxWidth(50.0);
        indicator.setMaxHeight(50.0);
        this.loadingIndicator.getChildren().add((Object)indicator);
        this.parentScreen = parentScreen;
        this.serverUrl = new CompositeWidget("Server URL");
        this.serverAccountUserName = new CompositeWidget("Server Account User Name");
        this.serverAccountPassword = new CompositeWidget("Server Account Password", true);
        this.queueCode = new CompositeWidget("Queue Code");
        this.detailsHeight = new CompositeWidget("Details Height");
        this.detailsFontColor = new CompositeWidget("Details Font Color");
        this.summaryFontSize = new CompositeWidget("Summary Font Size");
        this.summaryFontColor = new CompositeWidget("Summary Font Color");
        this.refreshOrdersEvery = new CompositeWidget("Refresh Orders Every (Seconds)");
        this.queuePageSize = new CompositeWidget("Queue Page Size");
        this.saveSettings = new StyledButton("Save Settings");
        this.saveSettings.customOnMouseClicked(this, this::saveSettings);
        this.getChildren().add((Object)new SearchBox());
        this.draw();
    }

    private void saveSettings() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("server", this.serverUrl.getValue());
        map.put("loginid", this.serverAccountUserName.getValue());
        map.put("loginpassword", this.serverAccountPassword.getValue());
        map.put("queue_code", this.queueCode.getValue());
        map.put("details_font_color", this.detailsFontColor.getValue());
        map.put("details_font_size", this.detailsHeight.getValue());
        map.put("summary_font_color", this.summaryFontColor.getValue());
        map.put("summary_font_size", this.summaryFontSize.getValue());
        map.put("read_every_seconds", this.refreshOrdersEvery.getValue());
        map.put("queue_page_size", this.queuePageSize.getValue());
        DeliveryGeneralSettings.saveSetting(map);
        this.parentScreen.goToHome();
    }

    private void draw() {
        DeliveryGeneralSettings.loadSettings();
        this.readSettings();
        this.getChildren().clear();
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(20.0);
        grid.setVgap(20.0);
        this.addCompositeToGrid(grid, this.serverUrl);
        this.addCompositeToGrid(grid, this.serverAccountUserName);
        this.addCompositeToGrid(grid, this.serverAccountPassword);
        this.addCompositeToGrid(grid, this.queueCode);
        this.addCompositeToGrid(grid, this.detailsFontColor);
        this.addCompositeToGrid(grid, this.detailsHeight);
        this.addCompositeToGrid(grid, this.summaryFontColor);
        this.addCompositeToGrid(grid, this.summaryFontSize);
        this.addCompositeToGrid(grid, this.refreshOrdersEvery);
        this.addCompositeToGrid(grid, this.queuePageSize);
        grid.add((Node)this.saveSettings, this.calcCols(), this.currentRow);
        GridPane.setColumnSpan((Node)this.saveSettings, (Integer)4);
        GridPane.setHalignment((Node)this.saveSettings, (HPos)HPos.CENTER);
        this.centerPane.getChildren().add((Object)grid);
        this.setCenter((Node)this.centerPane);
    }

    private void addCompositeToGrid(GridPane grid, CompositeWidget widget) {
        grid.add((Node)widget.getLabelWidget(), this.calcCols(), this.currentRow);
        grid.add((Node)widget.getValueWidget(), this.calcCols(), this.currentRow);
    }

    private int calcCols() {
        ++this.currentCol;
        if (this.currentCol == 4) {
            ++this.currentRow;
            this.currentCol = 0;
        }
        return this.currentCol;
    }

    private void readSettings() {
        this.serverUrl.setValue(DeliveryGeneralSettings.getServerAddress());
        this.serverAccountUserName.setValue(DeliveryGeneralSettings.getLoginID());
        this.serverAccountPassword.setValue(DeliveryGeneralSettings.getLoginPassword());
        this.queueCode.setValue(DeliveryGeneralSettings.getQueueCode());
        this.detailsFontColor.setValue(DeliveryGeneralSettings.getDetailsFontColor());
        this.detailsHeight.setValue("" + DeliveryGeneralSettings.getDetailsHeight());
        this.summaryFontColor.setValue(DeliveryGeneralSettings.getSummaryFontColor());
        this.summaryFontSize.setValue("" + DeliveryGeneralSettings.getSummaryFontSize());
        this.refreshOrdersEvery.setValue("" + DeliveryGeneralSettings.getReadEverySeconds());
        this.queuePageSize.setValue("" + DeliveryGeneralSettings.getQueuePageSize());
    }

    @Override
    public String getMenuItemKey() {
        return ScreenWithMenuBar.SETTINGS_SCREEN;
    }

    @Override
    public void showLoadingIndicator() {
        this.centerPane.getChildren().add((Object)this.loadingIndicator);
    }

    @Override
    public void hideLoadingIndicator() {
        this.centerPane.getChildren().remove((Object)this.loadingIndicator);
    }

    static class CompositeWidget
    extends HBox {
        private StyledText label;
        private StyledTextField value;
        private PasswordField passwordValue;
        private boolean passwordField;

        private CompositeWidget() {
            super(10.0);
        }

        public CompositeWidget(String text) {
            this();
            this.draw(text);
        }

        public CompositeWidget(String text, boolean password) {
            this();
            this.passwordField = password;
            this.draw(text);
        }

        private void draw(String text) {
            this.label = new StyledText(text);
            this.value = new StyledTextField();
            this.value.setMinWidth(100.0);
            this.passwordValue = new PasswordField();
            this.passwordValue.setMinWidth(100.0);
            VBox labelBox = new VBox(new Node[]{this.label});
            labelBox.setAlignment(Pos.CENTER);
            VBox valueBox = new VBox();
            if (this.passwordField) {
                valueBox.getChildren().add((Object)this.passwordValue);
            } else {
                valueBox.getChildren().add((Object)this.value);
            }
            valueBox.setAlignment(Pos.CENTER);
            this.getChildren().addAll((Object[])new Node[]{labelBox, valueBox});
            this.value.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty().divide(4).multiply(3));
        }

        public String getValue() {
            if (this.passwordField) {
                return this.passwordValue.getText();
            }
            return this.value.getText();
        }

        public void setValue(String value) {
            if (this.passwordField) {
                this.passwordValue.setText(value);
            } else {
                this.value.setText(value);
            }
        }

        public StyledText getLabelWidget() {
            return this.label;
        }

        public TextInputControl getValueWidget() {
            return this.passwordField ? this.passwordValue : this.value;
        }
    }
}

