/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.utils;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.CryptoUtils;
import com.namasoft.common.utils.GeneralSettings;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import java.util.Map;
import java.util.Properties;

public class DeliveryGeneralSettings
extends GeneralSettings {
    private static final String FILE_NAME = "delivery.properties";

    public static void loadSettings() {
        DeliveryGeneralSettings.setSettingsFilePath((String)FILE_NAME);
        properties = GeneralSettings.load();
        DeliveryGeneralSettings.initProperties();
    }

    private static void initProperties() {
        DeliveryGeneralSettings.addDefaultIfEmpty("details_font_size", "100");
        DeliveryGeneralSettings.addDefaultIfEmpty("details_font_color", "black");
        DeliveryGeneralSettings.addDefaultIfEmpty("summary_font_size", "20");
        DeliveryGeneralSettings.addDefaultIfEmpty("summary_font_color", "black");
        DeliveryGeneralSettings.addDefaultIfEmpty("queue_code", "1");
        DeliveryGeneralSettings.addDefaultIfEmpty("read_every_seconds", "5");
        DeliveryGeneralSettings.addDefaultIfEmpty("server", "http://localhost:8080/");
        DeliveryGeneralSettings.addDefaultIfEmpty("loginid", "admin");
        DeliveryGeneralSettings.addDefaultIfEmpty("loginpassword", "12345");
        DeliveryGeneralSettings.addDefaultIfEmpty("queue_page_size", "25");
        DeliveryGeneralSettings.saveSetting((Properties)properties, e -> DeliveryQueueUtils.showError(e));
    }

    private static void addDefaultIfEmpty(String key, String value) {
        if (ObjectChecker.isNotEmptyOrNull((Object)properties.get(key))) {
            return;
        }
        properties.put(key, value);
    }

    public static void saveSetting(Map<String, String> map) {
        properties.clear();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (ObjectChecker.areEqual((Object)entry.getKey(), (Object)"loginpassword")) {
                value = "$EN$:-".concat(CryptoUtils.encrypt((String)value));
            }
            properties.put(entry.getKey(), value);
        }
        DeliveryGeneralSettings.saveSetting((Properties)properties, e -> DeliveryQueueUtils.showError(e));
    }

    public static void saveSetting(Pair<String, String> pair) {
        properties.put(pair.getX(), pair.getY());
        DeliveryGeneralSettings.saveSetting((Properties)properties, e -> DeliveryQueueUtils.showError(e));
    }

    public static Double getDetailsHeight() {
        return Double.parseDouble(DeliveryGeneralSettings.getProperty((String)"details_font_size"));
    }

    public static String getDetailsFontColor() {
        return DeliveryGeneralSettings.getProperty((String)"details_font_color");
    }

    public static Double getSummaryFontSize() {
        return Double.parseDouble(DeliveryGeneralSettings.getProperty((String)"summary_font_size"));
    }

    public static String getSummaryFontColor() {
        return DeliveryGeneralSettings.getProperty((String)"summary_font_color");
    }

    public static String getQueueCode() {
        return DeliveryGeneralSettings.getProperty((String)"queue_code");
    }

    public static String getLoginID() {
        return DeliveryGeneralSettings.getProperty((String)"loginid");
    }

    public static String getLoginPassword() {
        return DeliveryGeneralSettings.findSecuredPassword((String)"loginpassword", (String)"login");
    }

    public static Integer getReadEverySeconds() {
        return ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{ObjectChecker.tryParseInt((String)DeliveryGeneralSettings.getProperty((String)"read_every_seconds")), 50});
    }

    public static int getQueuePageSize() {
        return ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{ObjectChecker.tryParseInt((String)DeliveryGeneralSettings.getProperty((String)"queue_page_size")), 25});
    }
}

