/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.utils;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.delivery_queue.DeliveryQueueEntryPoint;
import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.utils.DeliveryGeneralSettings;
import com.namasoft.delivery_queue.utils.DeliveryQueueUtils;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.supplychain.contracts.DTOFetchDeliveryOrderRequest;
import com.namasoft.modules.supplychain.contracts.DTOFetchDeliveryOrderResponse;
import com.namasoft.modules.supplychain.contracts.DTOWriteDeliveryOrderRequest;
import com.namasoft.modules.supplychain.contracts.SupplyChainUtilityWS;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTODeliveryQueueEntry;
import java.util.ArrayList;
import java.util.List;

public class DeliveryQueueReaderUtil {
    private static DeliveryQueueReaderUtil instance;
    public static String TODAY_QUEUE;
    public static String POSTPONED_QUEUE;
    public static String DELIVERED;
    public static String IN_PROGRESS;
    public static String NOT_DELIVERED;

    public static DeliveryQueueReaderUtil instance() {
        if (instance == null) {
            instance = new DeliveryQueueReaderUtil();
        }
        return instance;
    }

    private DeliveryQueueReaderUtil() {
    }

    public static SupplyChainUtilityWS getSupplyChainWS() throws Exception {
        return (SupplyChainUtilityWS)ServiceUtility.getUtilityServiceClient(SupplyChainUtilityWS.class, (String)"supplychain");
    }

    public DTOFetchDeliveryOrderResponse readData(DTOFetchDeliveryOrderRequest request) {
        try {
            this.loginIfNeeded();
            return (DTOFetchDeliveryOrderResponse)DeliveryQueueReaderUtil.getSupplyChainWS().readNamaDeliveryQueueEntries(new SendRequest((Object)request)).getData();
        }
        catch (Exception e) {
            DeliveryQueueUtils.showError(e);
            return new DTOFetchDeliveryOrderResponse();
        }
    }

    public void writeData(List<DeliveryOrder> orders) {
        try {
            if (ObjectChecker.isEmptyOrNull(orders)) {
                return;
            }
            this.loginIfNeeded();
            DTOWriteDeliveryOrderRequest request = new DTOWriteDeliveryOrderRequest();
            request.setDeliveryQueueCode(DeliveryGeneralSettings.getQueueCode());
            ArrayList<DTODeliveryQueueEntry> list = new ArrayList<DTODeliveryQueueEntry>();
            for (DeliveryOrder order : orders) {
                DTODeliveryQueueEntry entry = new DTODeliveryQueueEntry();
                list.add(entry);
                entry.setId(order.getNamaEntryId());
                entry.setDeliveryStatus(order.getStatus());
                entry.setPostponed(order.getPostponed());
                entry.setActualDeliveryDate(order.getDeliveryOrderDate());
            }
            request.setOrders(list);
            SendRequest sendRequest = new SendRequest((Object)request);
            DeliveryQueueReaderUtil.getSupplyChainWS().writeNamaDeliveryQueueEntries(sendRequest);
        }
        catch (Exception e) {
            DeliveryQueueUtils.showError(e);
        }
    }

    private void loginIfNeeded() throws Exception {
        String serverUrl = DeliveryGeneralSettings.getServerAddress();
        String userName = DeliveryGeneralSettings.getLoginID();
        String password = DeliveryGeneralSettings.getLoginPassword();
        ServiceLoginProvider.loginIfNotLoggedIn((String)serverUrl, (String)password, (String)userName);
    }

    public boolean login(String masterPin) {
        String message = "";
        try {
            this.loginIfNeeded();
            DTOWriteDeliveryOrderRequest request = new DTOWriteDeliveryOrderRequest();
            request.setMasterPin(masterPin);
            request.setDeliveryQueueCode(DeliveryGeneralSettings.getQueueCode());
            SendRequest sendRequest = new SendRequest((Object)request);
            message = (String)DeliveryQueueReaderUtil.getSupplyChainWS().deliveryQueueLogin(sendRequest).getData();
            DeliveryQueueEntryPoint.showPopup(message);
        }
        catch (Exception e) {
            DeliveryQueueUtils.showError(e);
        }
        return ObjectChecker.areEqual((Object)message, (Object)"success");
    }

    static {
        TODAY_QUEUE = "Today";
        POSTPONED_QUEUE = "Postponed";
        DELIVERED = "Delivered";
        IN_PROGRESS = "InProgress";
        NOT_DELIVERED = "NotDelivered";
    }
}

