/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.delivery_queue.utils;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.NaMaError;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.delivery_queue.DeliveryQueueEntryPoint;
import com.namasoft.delivery_queue.entities.DeliveryOrder;
import com.namasoft.delivery_queue.utils.DeliveryGeneralSettings;
import com.namasoft.delivery_queue.utils.DeliveryPageInfo;
import com.namasoft.delivery_queue.utils.DeliveryQueueReaderUtil;
import com.namasoft.delivery_queue.utils.IListenerScreen;
import com.namasoft.modules.supplychain.contracts.DTOFetchDeliveryOrderPageInfo;
import com.namasoft.modules.supplychain.contracts.DTOFetchDeliveryOrderRequest;
import com.namasoft.modules.supplychain.contracts.DTOFetchDeliveryOrderResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.application.Platform;

public class DeliveryQueueUtils {
    private int todayCurrentPage;
    private int postponedCurrentPage;
    private final Map<String, DeliveryPageInfo> queueOrdersPageInfoMap = new HashMap<String, DeliveryPageInfo>();
    private final List<DeliveryOrder> inProgressOrders = new ArrayList<DeliveryOrder>();
    private final List<IListenerScreen> currentListeners = new ArrayList<IListenerScreen>();
    private static DeliveryQueueUtils instance;

    private DeliveryQueueUtils() {
    }

    public static void init() {
        DeliveryQueueUtils.updateDeliveryQueueOrdersAndNotifyListeners();
    }

    public static void moveToPage(String key, int page) {
        if (ObjectChecker.areEqual((Object)key, (Object)DeliveryQueueReaderUtil.TODAY_QUEUE)) {
            DeliveryQueueUtils.instance().todayCurrentPage = page;
        } else {
            DeliveryQueueUtils.instance().postponedCurrentPage = page;
        }
        DeliveryQueueUtils.updateDeliveryQueueOrdersAndNotifyListeners();
    }

    public static void listen(IListenerScreen listener) {
        DeliveryQueueUtils.instance().currentListeners.add(listener);
    }

    private static DeliveryQueueUtils instance() {
        if (instance == null) {
            instance = new DeliveryQueueUtils();
            new Timer().schedule((TimerTask)new DeliveryQueueUpdater(), 0L, (long)(DeliveryGeneralSettings.getReadEverySeconds() * 1000));
        }
        return instance;
    }

    public static void postponedOrder(String key, DeliveryOrder currentOrder) {
        DeliveryQueueUtils.addToQueueTab(key, currentOrder);
        DeliveryQueueUtils.instance().inProgressOrders.remove(currentOrder);
        DeliveryQueueReaderUtil.instance().writeData(Collections.singletonList(currentOrder));
        DeliveryQueueUtils.instance().notifyListener();
    }

    public static DeliveryPageInfo getPageInfo(String key) {
        DeliveryPageInfo info = DeliveryQueueUtils.instance().queueOrdersPageInfoMap.get(key);
        if (info == null) {
            info = new DeliveryPageInfo();
        }
        info.getOrders().removeAll(DeliveryQueueUtils.instance().inProgressOrders);
        return info;
    }

    public static DeliveryOrder serveNextOrder(DeliveryOrder order, String key) {
        if (order == null) {
            return null;
        }
        DeliveryQueueUtils.instance().inProgressOrders.add(order);
        List<DeliveryOrder> orderList = DeliveryQueueUtils.instance().queueOrdersPageInfoMap.get(key).getOrders();
        if (orderList != null) {
            orderList.remove(order);
        }
        return order;
    }

    private static void addToQueueTab(String key, DeliveryOrder order) {
        DeliveryPageInfo info = DeliveryQueueUtils.instance().queueOrdersPageInfoMap.get(key);
        if (info == null) {
            info = new DeliveryPageInfo();
        }
        CollectionsUtility.addToList(info.getOrders(), (int)-1, (Object)order);
        DeliveryQueueUtils.instance().queueOrdersPageInfoMap.put(key, info);
    }

    public static List<DeliveryOrder> getInProgressOrderList() {
        return DeliveryQueueUtils.instance().inProgressOrders;
    }

    public static void changeInProgressOrdersToNotDelivered() {
        CollectionsUtility.setInDetails(DeliveryQueueUtils.instance().inProgressOrders, DeliveryOrder::setStatus, (Object)DeliveryQueueReaderUtil.NOT_DELIVERED);
        DeliveryQueueReaderUtil.instance().writeData(DeliveryQueueUtils.instance().inProgressOrders);
        DeliveryQueueUtils.instance().notifyListener();
    }

    public static void undoOrder(DeliveryOrder currentOrder) {
        DeliveryQueueUtils.instance().inProgressOrders.remove(currentOrder);
        DeliveryQueueUtils.instance().queueOrdersPageInfoMap.get(currentOrder.getFromTab()).getOrders().add(currentOrder);
        DeliveryQueueReaderUtil.instance().writeData(Collections.singletonList(currentOrder));
        DeliveryQueueUtils.instance().notifyListener();
    }

    public static void showError(Exception e) {
        NaMaLogger.error((Throwable)e);
        String message = e instanceof NaMaServiceExcepption ? NaMaError.createErrorsForLeafResults((ResultDTO)((NaMaServiceExcepption)e).getFaultInfo()).stream().map(error -> error.getMessage().getEnglishText()).collect(Collectors.joining("\n")) : e.getMessage();
        DeliveryQueueEntryPoint.showPopup(message);
    }

    public static void updateDeliveryQueueOrdersAndNotifyListeners() {
        DeliveryQueueUtils.updateDeliveryQueueOrders();
        DeliveryQueueUtils.instance().notifyListener();
    }

    public static void updateDeliveryQueueOrders() {
        DeliveryQueueUtils.instance().updateQueueOrdersMap();
        DTOFetchDeliveryOrderRequest request = new DTOFetchDeliveryOrderRequest();
        Date date = new Date();
        request.setDeliveryOrderDate(date);
        request.setDeliveryQueueCode(DeliveryGeneralSettings.getQueueCode());
        request.setPageSize(DeliveryGeneralSettings.getQueuePageSize());
        request.setTodayCurrentPage(DeliveryQueueUtils.instance().todayCurrentPage);
        request.setPostponedCurrentPage(DeliveryQueueUtils.instance().postponedCurrentPage);
        DTOFetchDeliveryOrderResponse response = DeliveryQueueReaderUtil.instance().readData(request);
        DeliveryQueueUtils.instance().updateQueueOrdersPageInfoMap(DeliveryQueueReaderUtil.TODAY_QUEUE, response.getToday(), DeliveryQueueUtils::updateTodayCurrentPage);
        DeliveryQueueUtils.instance().updateQueueOrdersPageInfoMap(DeliveryQueueReaderUtil.POSTPONED_QUEUE, response.getPostponed(), DeliveryQueueUtils::updatePostponedCurrentPage);
    }

    private void updateTodayCurrentPage(int page) {
        this.todayCurrentPage = page;
    }

    private void updatePostponedCurrentPage(int page) {
        this.postponedCurrentPage = page;
    }

    private void updateQueueOrdersMap() {
        this.queueOrdersPageInfoMap.clear();
        this.queueOrdersPageInfoMap.put(DeliveryQueueReaderUtil.TODAY_QUEUE, new DeliveryPageInfo());
        this.queueOrdersPageInfoMap.put(DeliveryQueueReaderUtil.POSTPONED_QUEUE, new DeliveryPageInfo());
    }

    private void updateQueueOrdersPageInfoMap(String key, DTOFetchDeliveryOrderPageInfo info, BiConsumer<DeliveryQueueUtils, Integer> consumer) {
        DeliveryPageInfo pageInfo = this.queueOrdersPageInfoMap.get(key);
        if (pageInfo == null) {
            pageInfo = new DeliveryPageInfo();
        }
        pageInfo.setCurrentPage(info.getCurrentPage());
        pageInfo.setPageSize(info.getPageSize());
        pageInfo.setTotalRecords(info.getTotalRecords());
        pageInfo.setOrders(CollectionsUtility.convert((Collection)info.getEntries(), DeliveryOrder::copyFrom));
        consumer.accept(this, info.getCurrentPage());
    }

    public static void markCurrentOrderAsServed(DeliveryOrder order) {
        DeliveryQueueReaderUtil.instance().writeData(Collections.singletonList(order));
        DeliveryQueueUtils.instance().inProgressOrders.remove(order);
        DeliveryQueueUtils.updateDeliveryQueueOrdersAndNotifyListeners();
        DeliveryQueueUtils.instance().notifyListener();
    }

    private void notifyListener() {
        if (ObjectChecker.isEmptyOrNull(this.currentListeners)) {
            NaMaLogger.warn((String)"No Listeners Found null for DeliveryQueueUtils", (Object[])new Object[0]);
            return;
        }
        for (IListenerScreen listener : this.currentListeners) {
            listener.updateView();
        }
    }

    public static DeliveryPageInfo getCurrentTabInfo(String key) {
        return DeliveryQueueUtils.instance().queueOrdersPageInfoMap.get(key);
    }

    public static boolean login(String masterPin) {
        return DeliveryQueueReaderUtil.instance().login(masterPin);
    }

    static class DeliveryQueueUpdater
    extends TimerTask {
        DeliveryQueueUpdater() {
        }

        @Override
        public void run() {
            Platform.runLater(DeliveryQueueUtils::updateDeliveryQueueOrdersAndNotifyListeners);
        }
    }
}

