package com.namasoft.common;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ServiceResponse implements Serializable
{
	private static final long serialVersionUID = -2851379978384766466L;
	private ResultDTO result;

	public ServiceResponse()
	{
		super();
		setResult(ResultDTO.success());
	}

	public ServiceResponse(ResultDTO result)
	{
		setResult(result);
	}

	public ResultDTO getResult()
	{
		return result;
	}

	public void setResult(ResultDTO result)
	{
		this.result = result;
	}

	public boolean succeded()
	{
		if (getResult() == null)
			return false;
		return getResult().isSucceded();
	}

}