package com.namasoft.common.cloudman.dtos;

import com.namasoft.common.utilities.ObjectChecker;

import java.math.BigDecimal;
import java.util.*;

public class CloudTomcat
{
	private String path;
	private String serverAddress;
	private String customerId;
	private String subServer;
	private Boolean running;
	private String serviceStartType;
	private String serviceStartName;
	private String maxMemory;
	private String jvm;
	private String guiServerURL;
	private CloudServer parentServer;
	private String serviceName;
	private BigDecimal dueBalance;
	private String databaseName;
	private String databaseUsername;
	private Long lastRefreshed;

	public String getPath()
	{
		return path;
	}

	public void setPath(String path)
	{
		this.path = path;
	}

	public String getServerAddress()
	{
		return serverAddress;
	}

	public void setServerAddress(String serverAddress)
	{
		this.serverAddress = serverAddress;
	}

	public String getCustomerId()
	{
		return customerId;
	}

	public void setCustomerId(String customerId)
	{
		this.customerId = customerId;
	}

	public String getSubServer()
	{
		return subServer;
	}

	public void setSubServer(String subServer)
	{
		this.subServer = subServer;
	}

	public Boolean getRunning()
	{
		return running;
	}

	public void setRunning(Boolean running)
	{
		this.running = running;
	}

	public String getMaxMemory()
	{
		return maxMemory;
	}

	public void setMaxMemory(String maxMemory)
	{
		this.maxMemory = maxMemory;
	}

	public String getJvm()
	{
		return jvm;
	}

	public void setJvm(String jvm)
	{
		this.jvm = jvm;
	}

	public String getGuiServerURL()
	{
		return guiServerURL;
	}

	public void setGuiServerURL(String guiServerURL)
	{
		this.guiServerURL = guiServerURL;
	}

	public CloudServer getParentServer()
	{
		return parentServer;
	}

	public void setParentServer(CloudServer parentServer)
	{
		this.parentServer = parentServer;
	}

	public CloudTomcat updateParentServer(CloudServer server, List<Map<String, Object>> balances)
	{
		setParentServer(server);
		setDueBalance(balances.stream().filter(b -> ObjectChecker.areEqual(b.get("customerLicenceId"), getCustomerId())).findFirst()
				.map(b -> ObjectChecker.tryParseDecimal(ObjectChecker.toStringOrEmpty(b.get("totalDebit")))).orElse(null));
		return this;
	}

	public void setServiceName(String serviceName)
	{
		this.serviceName = serviceName;
	}

	public String getServiceName()
	{
		return serviceName;
	}

	public String getServiceStartType()
	{
		return serviceStartType;
	}

	public void setServiceStartType(String serviceStartType)
	{
		this.serviceStartType = serviceStartType;
	}

	public String getServiceStartName()
	{
		return serviceStartName;
	}

	public void setServiceStartName(String serviceStartName)
	{
		this.serviceStartName = serviceStartName;
	}

	public BigDecimal getDueBalance()
	{
		return dueBalance;
	}

	public void setDueBalance(BigDecimal dueBalance)
	{
		this.dueBalance = dueBalance;
	}

	public String getDatabaseName()
	{
		return databaseName;
	}

	public void setDatabaseName(String databaseName)
	{
		this.databaseName = databaseName;
	}

	public String getDatabaseUsername()
	{
		return databaseUsername;
	}

	public void setDatabaseUsername(String databaseUsername)
	{
		this.databaseUsername = databaseUsername;
	}

	public Long getLastRefreshed()
	{
		return lastRefreshed;
	}

	public void setLastRefreshed(Long lastRefreshed)
	{
		this.lastRefreshed = lastRefreshed;
	}
}
