package com.namasoft.common.ecommerce;

public enum AmazonMarketplaces
{
	// North America
	US("ATVPDKIKX0DER", "United States", "us-east-1", "https://sellingpartnerapi-na.amazon.com", "https://sandbox.sellingpartnerapi-na.amazon.com"),

	CANADA("A2EUQ1WTGCTBG2", "Canada", "us-east-1", "https://sellingpartnerapi-na.amazon.com", "https://sandbox.sellingpartnerapi-na.amazon.com"),

	MEXICO("A1AM78C64UM0Y8", "Mexico", "us-east-1", "https://sellingpartnerapi-na.amazon.com", "https://sandbox.sellingpartnerapi-na.amazon.com"),

	BRAZIL("A2Q3Y263D00KWC", "Brazil", "us-east-1", "https://sellingpartnerapi-na.amazon.com", "https://sandbox.sellingpartnerapi-na.amazon.com"),

	// Europe
	UK("A1F83G8C2ARO7P", "United Kingdom", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	GERMANY("A1PA6795UKMFR9", "Germany", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	FRANCE("A13V1IB3VIYZZH", "France", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	ITALY("APJ6JRA9NG5V4", "Italy", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	SPAIN("A1RKKUPIHCS9HS", "Spain", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	NETHERLANDS("A1805IZSGTT6HS", "Netherlands", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	SWEDEN("A2NODRKZP88ZB9", "Sweden", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	POLAND("A1C3SOZBER8A3W", "Poland", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	BELGIUM("AMEN7PMS3EDWL", "Belgium", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	TURKEY("A33AVAJ2PDY3EV", "Turkey", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	// Middle East
	UAE("A2VIGQ35RCS4UG", "United Arab Emirates", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	SAUDI_ARABIA("A17E79C6D8DWNP", "Saudi Arabia", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	EGYPT("ARBP9OOSHTCHU", "Egypt", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com"),

	// Far East
	JAPAN("A1VC38T7YXB528", "Japan", "us-west-2", "https://sellingpartnerapi-fe.amazon.com", "https://sandbox.sellingpartnerapi-fe.amazon.com"),

	AUSTRALIA("A39IBJ37TRP1C6", "Australia", "us-west-2", "https://sellingpartnerapi-fe.amazon.com", "https://sandbox.sellingpartnerapi-fe.amazon.com"),

	SINGAPORE("A19VAU5U5O7RUS", "Singapore", "us-west-2", "https://sellingpartnerapi-fe.amazon.com", "https://sandbox.sellingpartnerapi-fe.amazon.com"),

	// India
	INDIA("A21TJRUUN4KGV", "India", "eu-west-1", "https://sellingpartnerapi-eu.amazon.com", "https://sandbox.sellingpartnerapi-eu.amazon.com");

	private final String marketplaceId;
	private final String countryName;
	private final String awsRegion;
	private final String spApiEndpoint;
	private final String sandboxEndpoint;

	AmazonMarketplaces(String marketplaceId, String countryName, String awsRegion, String spApiEndpoint, String sandboxEndpoint)
	{
		this.marketplaceId = marketplaceId;
		this.countryName = countryName;
		this.awsRegion = awsRegion;
		this.spApiEndpoint = spApiEndpoint;
		this.sandboxEndpoint = sandboxEndpoint;
	}

	public String getMarketplaceId()
	{
		return marketplaceId;
	}

	public String getCountryName()
	{
		return countryName;
	}

	public String getAwsRegion()
	{
		return awsRegion;
	}

	public String getSpApiEndpoint()
	{
		return spApiEndpoint;
	}

	public String getSandboxEndpoint()
	{
		return sandboxEndpoint;
	}

	public String getBaseUrl(boolean sandbox)
	{
		return sandbox ? sandboxEndpoint : spApiEndpoint;
	}

	// ========== Region Grouping Methods ==========

	public boolean isNorthAmerica()
	{
		return this == US || this == CANADA || this == MEXICO || this == BRAZIL;
	}

	public boolean isEurope()
	{
		return this == UK || this == GERMANY || this == FRANCE || this == ITALY || this == SPAIN || this == NETHERLANDS || this == SWEDEN
				|| this == POLAND || this == BELGIUM || this == TURKEY;
	}

	public boolean isMiddleEast()
	{
		return this == UAE || this == SAUDI_ARABIA || this == EGYPT;
	}

	public boolean isFarEast()
	{
		return this == JAPAN || this == AUSTRALIA || this == SINGAPORE;
	}

	public boolean isIndia()
	{
		return this == INDIA;
	}

	public boolean isArabic()
	{
		return this == UAE || this == SAUDI_ARABIA || this == EGYPT;
	}

	public boolean isEnglishSpeaking()
	{
		return this == US || this == CANADA || this == UK || this == AUSTRALIA || this == SINGAPORE || this == INDIA;
	}

	// ========== Lookup Methods ==========

	public static AmazonMarketplaces fromMarketplaceId(String marketplaceId)
	{
		if (marketplaceId == null || marketplaceId.isEmpty())
			return null;

		for (AmazonMarketplaces marketplace : values())
		{
			if (marketplace.marketplaceId.equals(marketplaceId))
				return marketplace;
		}
		return null;
	}

	public static String getAwsRegionForMarketplaceId(String marketplaceId)
	{
		AmazonMarketplaces marketplace = fromMarketplaceId(marketplaceId);
		return marketplace != null ? marketplace.awsRegion : "us-east-1";
	}

	public static String getSpApiEndpointForMarketplaceId(String marketplaceId)
	{
		AmazonMarketplaces marketplace = fromMarketplaceId(marketplaceId);
		return marketplace != null ? marketplace.spApiEndpoint : "https://sellingpartnerapi-na.amazon.com";
	}

	public static String getSandboxEndpointForMarketplaceId(String marketplaceId)
	{
		AmazonMarketplaces marketplace = fromMarketplaceId(marketplaceId);
		return marketplace != null ? marketplace.sandboxEndpoint : "https://sandbox.sellingpartnerapi-na.amazon.com";
	}

	public static String getEndpointForMarketplaceId(String marketplaceId, boolean sandbox)
	{
		AmazonMarketplaces marketplace = fromMarketplaceId(marketplaceId);
		if (marketplace == null)
			return sandbox ? "https://sandbox.sellingpartnerapi-na.amazon.com" : "https://sellingpartnerapi-na.amazon.com";
		return marketplace.getBaseUrl(sandbox);
	}
}
