package com.namasoft.common.flatobjects;

import com.namasoft.common.*;
import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.utilities.*;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings({ "unchecked" })
@XmlSeeAlso({ DateWrapper.class })
public class EntityReferenceData extends NaMaDTO implements NamaObject, HasId
{
	private static final long serialVersionUID = -2716412980198646035L;
	private static transient TrimmingInfoProvider trimmingInfoProvider = new TrimmingInfoProvider()
	{
		@Override
		public boolean shouldTrim()
		{
			return false;
		}
	};
	private String entityType;
	private String id;
	private String code;
	private String colorCode;
	private String actualCode;
	private String legalEntityId;
	private Map<String, Object> extraData;
	private Date valueDate;
	private String descriptor1;
	private String descriptor2;
	private String altCode;
	private String name1;
	private String name2;
	private Boolean hasImage;
	public static EntityReferenceData id(String entityType, String id)
	{
		return new EntityReferenceData(entityType, id, null, (String) null);
	}

	public static EntityReferenceData code(String entityType, String code)
	{
		return new EntityReferenceData(entityType, null, code, code);
	}

	public EntityReferenceData(String entityType, String id, String code, String actualCode)
	{
		super();
		this.entityType = entityType;
		this.id = id;
		this.code = code;
		this.actualCode = actualCode;
	}

	public static EntityReferenceData doc(String entityType, String id, String code, Date valueDate)
	{
		return new EntityReferenceData(entityType, id, code, valueDate);
	}

	public EntityReferenceData(String entityType, String id, String code)
	{
		this(entityType, id, code, (Date) null);
	}
	public EntityReferenceData(String entityType, String id, String code, Date valueDate)
	{
		super();
		this.entityType = entityType;
		this.id = id;
		this.code = code;
		this.setValueDate(valueDate);

	}

	public EntityReferenceData()
	{
		this.id = "";
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	@XmlTransient
	public String getG2Id()
	{
		return id;
	}

	public void setG2Id(String id)
	{
		if (ObjectChecker.isNotEmptyOrNull(id))
			this.id = id;
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	public Map<String, Object> getExtraData()
	{
		if (trimmingInfoProvider().shouldTrim())
			return null;
		return extraData;
	}

	public Map<String, Object> extraData()
	{
		return extraData;
	}

	public void setExtraData(Map<String, Object> extraData)
	{
		this.extraData = extraData;
	}

	public EntityReferenceData put(String key, Object value)
	{
		if (extraData == null)
			extraData = new HashMap<String, Object>();
		extraData.put(key, value);
		return this;
	}

	public <T> T get(String key)
	{
		if (extraData == null)
			extraData = new HashMap<>();
		return (T) extraData.get(key);
	}

	@XmlTransient
	public boolean isEmpty()
	{
		return (getId() == null) || getId().isEmpty();
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj == null || !obj.getClass().equals(this.getClass()))
			return false;
		if (this.getId() == ((EntityReferenceData) obj).getId())
			return true;
		if (this.getId() == null)
			return false;
		return this.getId().equals(((EntityReferenceData) obj).getId());
	}

	@Override
	public int hashCode()
	{
		return getId().hashCode();
	}

	public static void setTrimmingInfoProvider(TrimmingInfoProvider trimmingInfoProvider)
	{
		EntityReferenceData.trimmingInfoProvider = trimmingInfoProvider;
	}

	public static TrimmingInfoProvider trimmingInfoProvider()
	{
		return trimmingInfoProvider;
	}

	public void addExtraData(String fieldId, Object fieldValue)
	{
		if (getExtraData() == null)
			setExtraData(new HashMap<String, Object>());
		getExtraData().put(fieldId, fieldValue);
	}

	public Date getValueDate()
	{
		return valueDate;
	}

	public void setValueDate(Date valueDate)
	{
		this.valueDate = valueDate;
	}

	@Override
	public String toString()
	{
		return getEntityType() + ": " + getCode();
	}

	public String getActualCode()
	{
		return actualCode;
	}

	public void setActualCode(String actualCode)
	{
		this.actualCode = actualCode;
	}

	public String getLegalEntityId()
	{
		return legalEntityId;
	}

	public void setLegalEntityId(String legalEntityId)
	{
		this.legalEntityId = legalEntityId;
	}

	public EntityReferenceData toDocumentRef()
	{
		return new EntityReferenceData(getEntityType(), getId(), getCode(), getValueDate());
	}

	public EntityReferenceData toMasterRef()
	{
		return this;
	}

	public String getDescriptor1()
	{
		return descriptor1;
	}

	public String getDescriptor2()
	{
		return descriptor2;
	}

	public void setDescriptor1(String descriptor1)
	{
		this.descriptor1 = descriptor1;
	}

	public void setDescriptor2(String descriptor2)
	{
		this.descriptor2 = descriptor2;
	}

	public String getColorCode()
	{
		return colorCode;
	}

	public void setColorCode(String colorCode)
	{
		this.colorCode = colorCode;
	}

	public EntityReferenceData(String entityType, String id, String code, String actualCode, String altCode, String name1, String name2)
	{
		this(entityType, id, code, actualCode);
		this.name1 = name1;
		this.name2 = name2;
		this.altCode = altCode;
	}

	public EntityReferenceData(EntityReferenceData entityReferenceData)
	{
		this(entityReferenceData.getEntityType(), entityReferenceData.getId(), entityReferenceData.getCode(), null, null, null, null);
	}

	public EntityReferenceData(String entityType, String id)
	{
		setEntityType(entityType);
		setId(id);
	}

	public String getAltCode()
	{
		return altCode;
	}

	public void setAltCode(String altCode)
	{
		this.altCode = altCode;
	}

	public String getName1()
	{
		if (trimmingInfoProvider().shouldTrim())
			return null;
		return name1;
	}

	public void setName1(String name1)
	{
		this.name1 = name1;
	}

	public String getName2()
	{
		if (trimmingInfoProvider().shouldTrim())
			return null;
		return name2;
	}

	public void setName2(String name2)
	{
		this.name2 = name2;
	}

	public Boolean getHasImage()
	{
		return hasImage;
	}

	public void setHasImage(Boolean hasImage)
	{
		this.hasImage = hasImage;
	}

	public void simplifyForAi()
	{
		setActualCode(null);
		setExtraData(null);
		setColorCode(null);
		setLegalEntityId(null);
		setAltCode(null);
		setHasImage(null);
	}
}
