package com.namasoft.common.flatobjects;

import java.io.File;
import java.io.IOException;

public interface JSONAndDTOProvider
{
	Class getDTOClassFor(String entityType);

	Object readJSON(String jsonData, Class klass) throws IOException;

	Object readJSONFromFile(String fileName, Class klass) throws IOException;

	Object readListJSON(String jsonData, Class listElementsClass) throws IOException;

	String toJSON(Object o);

	void writeAsJSONToFile(Object o, File file) throws IOException;

	void writeAsPrettyJSONToFile(Object o, File file) throws IOException;

	void setCurrentLoginInfoFromRequest(IServiceRequest request);

	void cleanupCurrentLoginInfo();
}
