package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

abstract class AbsCounterNode extends RenderNode
{
	private final String nodeContent;
	private final String name;

	public AbsCounterNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.name = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (isIncrement())
			renderer.counters.compute(name, (k, o) -> ObjectChecker.toZeroIfNull(o) + 1);
		else if (isDecrement())
			renderer.counters.compute(name, (k, o) -> ObjectChecker.toZeroIfNull(o) - 1);
		else
			builder.append(ObjectChecker.toZeroIfNull(renderer.counters.get(name)));
	}

	protected boolean isIncrement()
	{
		return false;
	}

	protected boolean isDecrement()
	{
		return false;
	}
}
