package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.PlaceTokens;

import static com.namasoft.common.constants.PlaceTokens.*;
import static com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.pair;

public class EntityFlowLinkNode extends AbsLinkNode
{
	public EntityFlowLinkNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	protected String getPlaceToken(Object entityType, Object id, String resolvedMenuCode, String resolvedView, String resolvedFlowCode)
	{
		return PlaceTokens.tokenize("", pair(PRM_FLOW_ID, resolvedFlowCode), pair(PRM_FLOW_TARGET_TYPE, entityType), pair(PRM_FLOW_TARGET_ID, id));
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
