package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class TableNode extends PrefixSuffixCompositeNode
{
	public TableNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	protected Object prefix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return ComplexRenderer.OPEN_TABLE;
	}

	@Override
	protected Object suffix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "\n</table>";
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endtable");
	}
}
