package com.namasoft.common.layout.edit;

import com.namasoft.common.layout.TitledID;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@SuppressWarnings("serial")
public class EditScreenActionsBlock extends EditScreenBlock implements TitledID, ShowableInQuickCreate
{
	private List<GUIActionPlaceholder> actions = new ArrayList<GUIActionPlaceholder>();
	private String id;
	private String orderFromScreenModifier;
	public boolean getEditScreenActionsBlock()
	{
		return true;
	}

	public List<GUIActionPlaceholder> getActions()
	{
		return actions;
	}

	public void setActions(List<GUIActionPlaceholder> actions)
	{
		this.actions = actions;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public GUIActionPlaceholder addAction()
	{
		GUIActionPlaceholder action = new GUIActionPlaceholder();
		getActions().add(action);
		return action;
	}

	public EditScreenActionsBlock id(String id)
	{
		setId(id);
		return this;
	}

	public EditScreenActionsBlock title(NaMaText title)
	{
		setTitle(title);
		return this;
	}

	public EditScreenActionsBlock showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public EditScreenActionsBlock doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	public EditScreenActionsBlock addActions(String... ids)
	{
		for (String id : ids)
		{
			addAction().id(id);
		}
		return this;
	}

	public EditScreenActionsBlock addHiddenInNewGUIActions(String... ids)
	{
		for (String id : ids)
		{
			addAction().id(id).hideInNewGUI();
		}
		return this;
	}

	public String getOrderFromScreenModifier()
	{
		return orderFromScreenModifier;
	}

	public void setOrderFromScreenModifier(String orderFromScreenModifier)
	{
		this.orderFromScreenModifier = orderFromScreenModifier;
	}
}
