package com.namasoft.common.layout.list;

import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.utilities.ObjectChecker;

public interface HasDimensionIds
{
	String getLegalEntityId();

	String getSectorId();

	String getBranchId();

	String getDepartmentId();

	String getAnalysisSetId();

	Boolean getDoNotAddExtraCriteria();

	String getQueriedClass();

	HasDimensionIds NULL = new HasDimensionIds()
	{

		@Override
		public String getSectorId()
		{
			return null;
		}

		@Override
		public String getLegalEntityId()
		{
			return null;
		}

		@Override
		public String getDepartmentId()
		{
			return null;
		}

		@Override
		public String getBranchId()
		{
			return null;
		}

		@Override
		public String getAnalysisSetId()
		{
			return null;
		}

		public Boolean getDoNotAddExtraCriteria()
		{
			return false;
		}

		@Override
		public String getQueriedClass()
		{
			return null;
		}
	};

	static HasDimensionIds prefixed(String prefix, Class<?> queriedClass)
	{
		return new HasDimensionIds()
		{
			@Override
			public String getLegalEntityId()
			{
				if (ObjectChecker.isEmptyOrNull(prefix))
					return CommonFieldIds.LEGAL_ENTITY;
				return prefix + "." + CommonFieldIds.LEGAL_ENTITY;
			}

			@Override
			public String getSectorId()
			{
				if (ObjectChecker.isEmptyOrNull(prefix))
					return CommonFieldIds.SECTOR;
				return prefix + "." + CommonFieldIds.SECTOR;
			}

			@Override
			public String getBranchId()
			{
				if (ObjectChecker.isEmptyOrNull(prefix))
					return CommonFieldIds.BRANCH;
				return prefix + "." + CommonFieldIds.BRANCH;
			}

			@Override
			public String getDepartmentId()
			{
				if (ObjectChecker.isEmptyOrNull(prefix))
					return CommonFieldIds.DEPARTMENT;
				return prefix + "." + CommonFieldIds.DEPARTMENT;
			}

			@Override
			public String getAnalysisSetId()
			{
				if (ObjectChecker.isEmptyOrNull(prefix))
					return CommonFieldIds.ANALYSISSET;
				return prefix + "." + CommonFieldIds.ANALYSISSET;
			}

			@Override
			public Boolean getDoNotAddExtraCriteria()
			{
				return false;
			}

			@Override
			public String getQueriedClass()
			{
				return queriedClass.getName();
			}
		};
	}
}
