package com.namasoft.common.layout.metadata;

import com.namasoft.common.*;
import com.namasoft.common.layout.list.*;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class ReportMetadata extends NaMaDTO implements HasQuestionFields
{
	private List<QuestionField> questionFields;
	private List<ReportQuestionFieldMetadata> metadata;
	private List<String> allParameterIds;
	private String ownerId;
	private String viewingFormat;
	private String reportDetails;
	private String preRunUtil;
	private String questionsChangeUtil;
	private List<String> reportGroups;
	private Map<String, String> interestingProperties;

	public String getReportDetails()
	{
		return reportDetails;
	}

	public void setReportDetails(String reportDetails)
	{
		this.reportDetails = reportDetails;
	}

	@Override
	public List<QuestionField> getQuestionFields()
	{
		if (questionFields == null)
			questionFields = new ArrayList<QuestionField>();
		return questionFields;
	}

	@Override
	public void setQuestionFields(List<QuestionField> questionFields)
	{
		this.questionFields = questionFields;
	}

	@Override
	public QuestionField getQuestionField(String id)
	{
		return HasIDUtil.find(id, getQuestionFields());
	}

	public String getPreRunUtil()
	{
		return preRunUtil;
	}

	public void setPreRunUtil(String preRunUtil)
	{
		this.preRunUtil = preRunUtil;
	}

	public String getQuestionsChangeUtil()
	{
		return questionsChangeUtil;
	}

	public void setQuestionsChangeUtil(String questionsChangeUtil)
	{
		this.questionsChangeUtil = questionsChangeUtil;
	}

	public ReportQuestionFieldMetadata getReportQuestionFieldMetadata(String id)
	{
		return HasIDUtil.find(id, getMetadata());
	}
	public List<ReportQuestionFieldMetadata> getMetadata()
	{
		if (metadata == null)
			metadata = new ArrayList<>();
		return metadata;
	}

	public void setMetadata(List<ReportQuestionFieldMetadata> metadata)
	{
		this.metadata = metadata;
	}

	public Map<String, String> getInterestingProperties()
	{
		if (interestingProperties == null)
			interestingProperties = new HashMap<>();
		return interestingProperties;
	}

	public void setInterestingProperties(Map<String, String> interestingProperties)
	{
		this.interestingProperties = interestingProperties;
	}

	public List<String> getAllParameterIds()
	{
		if (allParameterIds == null)
			allParameterIds = new ArrayList<>();
		return allParameterIds;
	}

	public void setAllParameterIds(List<String> allParameterIds)
	{
		this.allParameterIds = allParameterIds;
	}

	public String getOwnerId()
	{
		return ownerId;
	}

	public void setOwnerId(String ownerId)
	{
		this.ownerId = ownerId;
	}

	public void merge(ReportMetadata subMetadata)
	{
		HasIDUtil.addIfNotFound(getMetadata(), subMetadata.getMetadata());
		HasIDUtil.addIfNotFound(getQuestionFields(), subMetadata.getQuestionFields());
		for (String param : subMetadata.getAllParameterIds())
		{
			if (!getAllParameterIds().contains(param))
				getAllParameterIds().add(param);
		}
	}

	public List<String> getReportGroups()
	{
		if (reportGroups == null)
			reportGroups = new ArrayList<>();
		return reportGroups;
	}

	public void setReportGroups(List<String> reportGroups)
	{
		this.reportGroups = reportGroups;
	}

	public String getViewingFormat()
	{
		return viewingFormat;
	}

	public void setViewingFormat(String viewingFormat)
	{
		this.viewingFormat = viewingFormat;
	}
}
