package com.namasoft.common.layout.metadata;

import jakarta.xml.bind.annotation.*;

import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ThemeColor implements Serializable
{
	private String lightColor;
	private String darkColor;

	public ThemeColor()
	{
	}

	public ThemeColor(String lightColor, String darkColor)
	{
		this.lightColor = lightColor;
		this.darkColor = darkColor;
	}

	public String getLightColor()
	{
		return lightColor;
	}

	public void setLightColor(String lightColor)
	{
		this.lightColor = lightColor;
	}

	public String getDarkColor()
	{
		return darkColor;
	}

	public void setDarkColor(String darkColor)
	{
		this.darkColor = darkColor;
	}

	public static ThemeColor of(String lightColor, String darkColor)
	{
		return new ThemeColor(lightColor, darkColor);
	}

	public static ThemeColor of(String color)
	{
		return new ThemeColor(color, color);
	}
}
