package com.namasoft.common.preferences;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.layout.Owner;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class LayoutPreferences implements Serializable, IScreenLayout
{
	private Owner owner;
	private String layoutId;
	private String preferencesId;

	public LayoutPreferences(Owner owner, String layoutId, String preferencesId)
	{
		this.owner = owner;
		this.layoutId = layoutId;
		this.preferencesId = preferencesId;
	}

	public LayoutPreferences()
	{

	}

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	public String getLayoutId()
	{
		return layoutId;
	}

	public void setLayoutId(String id)
	{
		this.layoutId = id;
	}

	public String getPreferencesId()
	{
		return preferencesId;
	}

	public void setPreferencesId(String preferencesId)
	{
		this.preferencesId = preferencesId;
	}

}
