package com.namasoft.common.treemodels;

import com.namasoft.common.constants.*;
import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.fieldids.newids.accounting.IdsOfAccount;
import com.namasoft.common.fieldids.newids.auditing.*;
import com.namasoft.common.utilities.ObjectChecker;

import java.util.*;
import java.util.function.Function;

public class CommonEntityViewCustomizer
{
	private static final List<String> HAS_IS_LEAF_ENTITIES;
	private static final List<String> HAS_PARENT_ENTITIES;

	static
	{
		HAS_PARENT_ENTITIES = new ArrayList<>();
		HAS_PARENT_ENTITIES.add(ACCEntities.AccountsChart);
		HAS_PARENT_ENTITIES.add(DomainBaseEntities.MasterGroup);
		HAS_PARENT_ENTITIES.add(FAEntities.FALocation);
		HAS_PARENT_ENTITIES.add(BSCEntities.RemarkType);
		HAS_PARENT_ENTITIES.add(BSCEntities.DMSFolder);
		HAS_PARENT_ENTITIES.add(auditingEntities.AUAccount);
		HAS_PARENT_ENTITIES.add(auditingEntities.AUPhase);
		HAS_PARENT_ENTITIES.add(auditingEntities.AUAnalysisPoint);
		HAS_PARENT_ENTITIES.add(EducationEntities.EDEducationalStage);
		HAS_PARENT_ENTITIES.add(CONTRACTINGEntities.ContrWorkArea);
		HAS_PARENT_ENTITIES.add(MCEntities.MCWorkArea);
		HAS_PARENT_ENTITIES.add(MCEntities.MCWorkerType);
		HAS_PARENT_ENTITIES.add(MCEntities.MCCostItemClass);
		Collections.sort(HAS_PARENT_ENTITIES);

		HAS_IS_LEAF_ENTITIES = new ArrayList<>();
		HAS_IS_LEAF_ENTITIES.add(DomainBaseEntities.MasterGroup);
		HAS_IS_LEAF_ENTITIES.add(ACCEntities.AccountsChart);
		HAS_IS_LEAF_ENTITIES.add(FAEntities.FALocation);
		HAS_IS_LEAF_ENTITIES.add(BSCEntities.RemarkType);
		HAS_IS_LEAF_ENTITIES.add(BSCEntities.DMSFolder);
		HAS_IS_LEAF_ENTITIES.add(auditingEntities.AUAccount);
		HAS_IS_LEAF_ENTITIES.add(auditingEntities.AUPhase);
		HAS_IS_LEAF_ENTITIES.add(auditingEntities.AUAnalysisPoint);
		HAS_IS_LEAF_ENTITIES.add(EducationEntities.EDEducationalStage);

		Collections.sort(HAS_IS_LEAF_ENTITIES);
	}

	public static boolean hasParentEntity(String entityType)
	{
		return Collections.binarySearch(HAS_PARENT_ENTITIES, entityType) >= 0;
	}

	public static boolean supportsTreeViewInEditView(String entityType)
	{
		if (hasParentEntity(entityType))
			return true;
		return false;
	}

	public static boolean entityHasIsLeafProperty(String entityType)
	{
		return Collections.binarySearch(HAS_IS_LEAF_ENTITIES, entityType) >= 0;
	}

	public static final TreeFilterHelper GROUP_FILTER_HELPER = new HierarchyFilterHelper("group." + CommonFieldIds.FULL_HIERARCHY_PATH);
	public static final TreeFilterHelper DMSDOCUMENT_FILTER_HELPER = new HierarchyFilterHelper("parent." + CommonFieldIds.FULL_HIERARCHY_PATH);
	public static final TreeFilterHelper PARENT_FILTER_HELPER = new HierarchyFilterHelper(CommonFieldIds.HIERARCHY_PATH);
	public static final TreeFilterHelper ACCOUNT_CHART_WHEN_DEBIT_FILTER_HELPER = new HierarchyFilterHelper(
			IdsOfAccount.chartWhenDebit + "." + CommonFieldIds.FULL_HIERARCHY_PATH);
	public static final TreeFilterHelper AU_PROCEDURES_AND_TEST_FILTER_HELPER = new HierarchyFilterHelper(
			IdsOfAUTestDef.phase + "." + IdsOfAUPhase.fullHierarchyPath);
	public static final TreeFilterHelper REMARK_TYPE_FILTER_HELPER = new HierarchyFilterHelper("remarkType." + CommonFieldIds.FULL_HIERARCHY_PATH);

	public static TreeFilterHelper getHelperForEditView(Function<String, Boolean> isMaster, String entityType)
	{
		if (CommonEntityViewCustomizer.hasParentEntity(entityType))
			return PARENT_FILTER_HELPER;
		if (isMaster.apply(entityType))
			return GROUP_FILTER_HELPER;
		return null;
	}

	public static TreeFilterHelper getHelperForListView(Function<String, Boolean> isMaster, String entityType)
	{
		if (ACCEntities.Account.equals(entityType))
			return ACCOUNT_CHART_WHEN_DEBIT_FILTER_HELPER;
		if (BSCEntities.Remark.equals(entityType))
			return REMARK_TYPE_FILTER_HELPER;
		if (BSCEntities.DetailedRemark.equals(entityType))
			return REMARK_TYPE_FILTER_HELPER;
		if (BSCEntities.DMSDocument.equals(entityType))
			return DMSDOCUMENT_FILTER_HELPER;
		if (ObjectChecker.isAnyEqualToFirst(entityType, auditingEntities.AUTestDef))
			return AU_PROCEDURES_AND_TEST_FILTER_HELPER;
		if (hasParentEntity(entityType))
			return PARENT_FILTER_HELPER;
		if (isMaster.apply(entityType))
			return GROUP_FILTER_HELPER;
		return null;
	}
}
