package com.namasoft.common.urlutils;

import java.math.BigDecimal;

import com.namasoft.common.utilities.SimpleEntry;

public class LatitudeLongitude
{
	public static SimpleEntry<BigDecimal, BigDecimal> extractLatAndLongFromURL(String url)
	{
		try
		{
			int x = url.indexOf("ll=");
			int y = url.indexOf("&", x);
			String latLong = url.substring(x, y);
			String[] array = latLong.split(",");
			return new SimpleEntry<>(new BigDecimal(array[0]), new BigDecimal(array[1]));
		}
		catch (Exception e)
		{
			return new SimpleEntry<>();
		}
	}

	public static double distance(double latt1, double lon1, double latt2, double lon2, char unit)
	{
		double theta = lon1 - lon2;
		double dist = Math.sin(deg2rad(latt1)) * Math.sin(deg2rad(latt2)) + Math.cos(deg2rad(latt1)) * Math.cos(deg2rad(latt2))
				* Math.cos(deg2rad(theta));
		dist = Math.acos(dist);
		dist = rad2deg(dist);
		dist = dist * 60 * 1.1515;
		if (unit == 'K')
		{
			dist = dist * 1.609344;
		}
		else if (unit == 'N')
		{
			dist = dist * 0.8684;
		}
		return Math.abs(dist);
	}

	private static double deg2rad(double deg)
	{
		return (deg * Math.PI / 180.0);
	}

	private static double rad2deg(double rad)
	{
		return (rad * 180.0 / Math.PI);
	}

	public static void main(String[] args)
	{
		System.out.println(distance(32.9697, -96.80322, 29.46786, -98.53506, 'M') + " Miles\n");
		System.out.println(distance(32.9697, -96.80322, 29.46786, -98.53506, 'K') + " Kilometers\n");
		extractLatAndLongFromURL("https://maps.google.com/maps?f=q&source=s_q&hl=en&geocode=&q=Namasoft,+Ad+Doqi,+Giza,+Egypt&aq=0&oq=nama&sll=30.041258,31.203041&sspn=0.067614,0.126514&vpsrc=0&ie=UTF8&hq=Namasoft,&hnear=Ad+Doqi,+Giza,+Egypt&t=m&z=16&iwloc=A&cid=10985563050972763160");
	}
}
