package com.namasoft.common.utils;

import com.namasoft.common.constants.PlaceTokens;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.urlutils.*;
import com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer;

import static com.namasoft.common.constants.PlaceTokens.*;
import static com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.pair;

public class ListViewUrlBuilder
{
	private String entityType;
	private DTOCriteria criteria;
	private Integer currentPage;
	private Integer pageSize;
	private String orderBy;
	private String listViewName;
	private Boolean ascending;
	private Boolean showTree;
	private String extraCriteriaId;
	private String menuCode;

	public ListViewUrlBuilder entityType(String entityType)
	{
		this.entityType = entityType;
		return this;
	}

	/**
	 *
	 * @param criteria a string criteria that can be created easily using the expression $P{REPORT_SCRIPTLET}.tempo("""
	 *                 field,Operator,{value},AND;
	 *                 """)
	 *                 You can use fields, parameters, or variables by name inside the curly brackets. You do not need to use $P{paramName} syntax, use {paramName} directly
	 *                 Same for variables and fields
	 */
	public ListViewUrlBuilder criteria(String criteria)
	{
		this.criteria = DTOCriteria.criteriaFromStr(criteria);
		return this;
	}

	public ListViewUrlBuilder currentPage(Integer currentPage)
	{
		this.currentPage = currentPage;
		return this;
	}

	public ListViewUrlBuilder pageSize(Integer pageSize)
	{
		this.pageSize = pageSize;
		return this;
	}

	public ListViewUrlBuilder orderBy(String orderBy)
	{
		this.orderBy = orderBy;
		return this;
	}

	public ListViewUrlBuilder listViewName(String listViewName)
	{
		this.listViewName = listViewName;
		return this;
	}

	public ListViewUrlBuilder ascending(Boolean ascending)
	{
		this.ascending = ascending;
		return this;
	}

	public ListViewUrlBuilder showTree(Boolean showTree)
	{
		this.showTree = showTree;
		return this;
	}

	public ListViewUrlBuilder extraCriteriaId(String extraCriteriaId)
	{
		this.extraCriteriaId = extraCriteriaId;
		return this;
	}

	public ListViewUrlBuilder menuCode(String menuCode)
	{
		this.menuCode = menuCode;
		return this;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public Integer getCurrentPage()
	{
		return currentPage;
	}

	public void setCurrentPage(Integer currentPage)
	{
		this.currentPage = currentPage;
	}

	public Integer getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(Integer pageSize)
	{
		this.pageSize = pageSize;
	}

	public String getOrderBy()
	{
		return orderBy;
	}

	public void setOrderBy(String orderBy)
	{
		this.orderBy = orderBy;
	}

	public String getListViewName()
	{
		return listViewName;
	}

	public void setListViewName(String listViewName)
	{
		this.listViewName = listViewName;
	}

	public Boolean getAscending()
	{
		return ascending;
	}

	public void setAscending(Boolean ascending)
	{
		this.ascending = ascending;
	}

	public Boolean getShowTree()
	{
		return showTree;
	}

	public void setShowTree(Boolean showTree)
	{
		this.showTree = showTree;
	}

	public String getExtraCriteriaId()
	{
		return extraCriteriaId;
	}

	public void setExtraCriteriaId(String extraCriteriaId)
	{
		this.extraCriteriaId = extraCriteriaId;
	}

	public String getMenuCode()
	{
		return menuCode;
	}

	public void setMenuCode(String menuCode)
	{
		this.menuCode = menuCode;
	}

	private NaMaKeyValuePairsTokenizer.KeyValuePair[] tokens()
	{
		boolean isAll = getPageSize() != null && getPageSize() == -1;
		return new NaMaKeyValuePairsTokenizer.KeyValuePair[] { pair(PRM_ENTITY_TYPE, getEntityType()), //
				pair(PRM_SORT_BY, getOrderBy()),//
				pair(PRM_LIST_VIEW_NAME, getListViewName()),//
				pair(PRM_PAGE, getCurrentPage()), //
				pair(PRM_PAGE_SIZE, isAll ? "all" : getPageSize()), //
				pair(PRM_CRITERIA, CriteriaAndQuestionsURLParser.toURL(getCriteria())),//
				pair(PRM_ASCENDING, getAscending()),//
				pair(PRM_EXTRA_CRITERIA, getExtraCriteriaId()),//
				pair(PRM_SHOW_TREE, getShowTree()),//
				pair(PRM_MENU_HASH, getMenuCode()) };
	}

	@Override
	public String toString()
	{
		return ReportQuestions.calcGuiServerURL() + PlaceTokens.tokenize(PREFIX_LIST, tokens());
	}
}
