package com.namasoft.common.utils;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

import org.apache.commons.io.FileUtils;

import com.namasoft.common.utilities.NaMaLogger;

public class NamaTempFiles
{
	public static File createTempFile()
	{
		return new File(createTempFolder(), UUID.randomUUID().toString());
	}

	public static File createTempFolder()
	{
		File rootTempFolder = new File(GeneralSettings.getTempFolder());
		File todayTempFolder = new File(rootTempFolder, new SimpleDateFormat("yyyy_MM_dd").format(new Date()));
		File tempFolder = new File(todayTempFolder, UUID.randomUUID().toString());
		tempFolder.mkdirs();
		return tempFolder;
	}

	public static void deleteWithParentIfNeeded(String fileName)
	{
		File file = new File(fileName);
		File rootTemp = new File(GeneralSettings.getTempFolder());
		if (rootTemp.equals(file) || rootTemp.equals(file.getParent()))
		{
			file.delete();
		}
		else
		{
			try
			{
				FileUtils.deleteDirectory(file.getParentFile());
			}
			catch (IOException e)
			{
				NaMaLogger.info(e);
			}
		}
	}
}
