package com.namasoft.common.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.namasoft.common.constants.*;
import com.namasoft.common.utilities.ObjectChecker;

public class SupplyChainCommon
{
	private final static List<String> invReceiptDocTypes = Arrays
			.asList(SCEntities.InitialReceipt, SCEntities.ReceiptInspection, SCEntities.StockReceiptReq, SCEntities.StockReceipt,
					SCEntities.StockReceiptCancellation, SCEntities.SalesReturn);

	private final static List<String> invIssueDocTypes = Arrays.asList(SCEntities.StockIssueReq, SCEntities.StockIssue, SCEntities.ItemCuttingDoc,
			SCEntities.SalesInvoice, SCEntities.ProformaSalesInvoice, SCEntities.SalesOrder, SCEntities.CouponsSalesOrder, SCEntities.SalesQuotation,
			SCEntities.SalesQuotationRequest, SCEntities.ItemRequest, SCEntities.StockTransferReq, SCEntities.StockTransfer,
			SCEntities.ReceiptStockTransfer, SCEntities.IssueStockTransfer, SCEntities.PurchaseReturn, SCEntities.GlassJobOrder,
			ManufacturingEntities.ProductReturn);

	private final static List<String> invSalesDocTypes = Arrays.asList(SCEntities.SalesInvoice, SCEntities.ProformaSalesInvoice,
			SCEntities.SalesOrder, SCEntities.CouponsSalesOrder, ServiceCenterEntities.RARentalInvoice, ServiceCenterEntities.RARentalRequest,
			SCEntities.SalesQuotation, SCEntities.SalesQuotationRequest);

	private final static List<String> hasWareInHeaderOnlyDocTypes = Arrays
			.asList(SCEntities.StockIssueReq, SCEntities.StockIssue, SCEntities.ItemCuttingDoc, SCEntities.StockReceiptReq, SCEntities.StockReceipt,
					SCEntities.StockReceiptCancellation);
	private static final Map<String, List<String>> allowedNextDocumentTypes = new HashMap<String, List<String>>();
	private static final List<String> allowedNDTForStokIssueReq = Arrays.asList(SCEntities.StockIssue);
	private static final List<String> allowedNDTForInitialReceipt = Arrays
			.asList(SCEntities.StockReceipt, SCEntities.StockReceiptReq, SCEntities.StockReceiptCancellation, SCEntities.ReceiptInspection);
	private static final List<String> allowedNDTForReceiptInspection = Arrays
			.asList(SCEntities.StockReceipt, SCEntities.StockReceiptReq, SCEntities.StockReceiptCancellation);
	private static final List<String> allowedNDTForStockReceiptReq = Arrays.asList(SCEntities.StockReceipt, SCEntities.StockReceiptCancellation);
	private static final List<String> allowedNDTForItemRequest = Arrays.asList(SCEntities.StockIssue, SCEntities.StockIssueReq);

	static
	{
		Collections.sort(invIssueDocTypes);
		Collections.sort(invReceiptDocTypes);
		Collections.sort(hasWareInHeaderOnlyDocTypes);
		allowedNextDocumentTypes.put(SCEntities.StockIssueReq, allowedNDTForStokIssueReq);
		allowedNextDocumentTypes.put(SCEntities.StockReceiptReq, allowedNDTForStockReceiptReq);
		allowedNextDocumentTypes.put(SCEntities.StockReceiptCancellation, allowedNDTForStockReceiptReq);
		allowedNextDocumentTypes.put(SCEntities.InitialReceipt, allowedNDTForInitialReceipt);
		allowedNextDocumentTypes.put(SCEntities.ReceiptInspection, allowedNDTForReceiptInspection);
		allowedNextDocumentTypes.put(SCEntities.ItemRequest, allowedNDTForItemRequest);
	}

	public static boolean isReceiptDocument(String entity)
	{
		return Collections.binarySearch(invReceiptDocTypes, entity) >= 0;
	}

	public static boolean isSalesDocument(String entity)
	{
		return Collections.binarySearch(invSalesDocTypes, entity) >= 0;
	}

	public static boolean isIssueDocument(String entity)
	{
		return Collections.binarySearch(invIssueDocTypes, entity) >= 0;
	}

	public static boolean isHasWareInHeaderOnlyDoc(String entity)
	{
		return Collections.binarySearch(hasWareInHeaderOnlyDocTypes, entity) >= 0;
	}

	public static boolean isNextDocumentTypeValid(String entityType, String nextDocumentType)
	{
		List<String> allowed = allowedNextDocumentTypes.get(entityType);
		if (ObjectChecker.isEmptyOrNull(allowed))
			return false;
		return allowed.contains(nextDocumentType);
	}
}
