package com.namasoft.common.utils;

import com.namasoft.common.utilities.*;

import java.io.*;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;

public class TomcatLibLoader
{
	public static void addURL(String jarPath)
	{
		try
		{
			//For jdk 9 and above, please add the following argument to JVM args
			//--add-opens java.base/jdk.internal.loader=ALL-UNNAMED
			ClassLoader classLoader = ClassLoader.getSystemClassLoader();
			try
			{
				Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
				method.setAccessible(true);
				method.invoke(classLoader, new File(jarPath).toURI().toURL());
			}
			catch (NoSuchMethodException e)
			{
				Method method = classLoader.getClass().getDeclaredMethod("appendToClassPathForInstrumentation", String.class);
				method.setAccessible(true);
				method.invoke(classLoader, jarPath);
			}
		}
		catch (Throwable e)
		{
			e.printStackTrace();
		}
	}

	private static boolean loaded = false;
	private static boolean shouldLoad = false;

	public static synchronized void loadTomcatLibIfNeeded()
	{
		LoggingConfigurator.logToConsoleOnly(true);
		if (!shouldLoad)
			return;
		if (loaded)
			return;
		loaded = true;
		try
		{
			if (ObjectChecker.isNotEmptyOrNull(System.getProperty("tomcatlib")) || new File(new File(WidgetStatePersister.getUserFolder()) , ".tomcatlibpath")
					.exists())
			{
				String tomcatLibPath = System.getProperty("tomcatlib");
				if (ObjectChecker.isEmptyOrNull(tomcatLibPath))
				{
					Properties properties = new Properties();
					InputStream is = new FileInputStream(new File(new File(WidgetStatePersister.getUserFolder()), ".tomcatlibpath"));
					properties.load(is);
					is.close();
					tomcatLibPath = properties.getProperty("tomcatlib");
				}
				if (ObjectChecker.isEmptyOrNull(tomcatLibPath))
					return;
				File file = new File(tomcatLibPath);
				addURL(file.getAbsolutePath());
				String[] jars = file.list((dir, name) -> name.endsWith(".jar"));
				for (String jar : jars)
				{
					addURL(new File(file, jar).getAbsolutePath());
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

}
