package com.namasoft.common.utils.importer.data;

import com.namasoft.common.*;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DetailEntry  extends NaMaDTO implements HasId
{
	private String table;
	private List<DetailEntryRow> rows = new ArrayList<>();

	public DetailEntry(String table)
	{
		this();
		setTable(table);
	}

	private DetailEntry()
	{
	}

	public String getTable()
	{
		return table;
	}

	public void setTable(String table)
	{
		this.table = table;
	}

	public List<DetailEntryRow> getRows()
	{
		return rows;
	}

	public void setRows(List<DetailEntryRow> rows)
	{
		this.rows = rows;
	}

	@Override
	public String toString()
	{
		StringBuilder toStr = new StringBuilder();
		toStr.append(getTable()).append(":{");
		for (DetailEntryRow row : getRows())
			toStr.append("\n  ").append(row).append(",");
		return toStr.append("}").toString();
	}

	@XmlTransient
	@Override
	public String getId()
	{
		return getTable();
	}

	public void mergeWith(DetailEntry source)
	{
		if (source == null)
			return;
		for (DetailEntryRow sourceRow : source.getRows())
		{
			if (ObjectChecker.isEmptyOrNull(sourceRow.getUniqueBy()))
			{
				getRows().add(sourceRow);
				continue;
			}
			DetailEntryRow targetRow = getRows().stream().filter(ObjectChecker.equalsPredicate(sourceRow.getUniqueBy(), DetailEntryRow::getUniqueBy))
					.findFirst().orElse(null);
			if (targetRow == null)
				getRows().add(sourceRow);
			else
				targetRow.mergeWith(sourceRow);
		}
	}
}
