package com.namasoft.common.utils.tafqeet;

import com.namasoft.common.constants.Language;

import java.math.BigDecimal;

public class MainClass
{

	public static void main(String[] args)
	{
		testArabic(new BigDecimal("10"), 1, "");
		testArabic(new BigDecimal("2"), 1, "");
		testArabic(new BigDecimal("1021"), 75, "");

		System.out.println("------------------English--------------------");
		testEnglish(new BigDecimal("10"), 1, "");
		testEnglish(new BigDecimal("210"), 1, "");
		testEnglish(new BigDecimal("1021"), 75, "");

		System.out.println("------------------French--------------------");
		testFrench(new BigDecimal("10"), 1, "");
		testFrench(new BigDecimal("210"), 1, "");
		testFrench(new BigDecimal("1021"), 75, "");
	}

	private static void testArabic(BigDecimal n, int f, String expected)
	{
		System.out.println(Converter.convertToWords( new BigDecimal(n + "." + f) , "EGP", Language.Arabic)	);
		System.out.println(expected);
	}

	private static void testEnglish(BigDecimal n, int f, String expected)
	{
		System.out.println(Converter.convertToWords(new BigDecimal(n + "." + f), "EGP", Language.English));
		System.out.println(expected);
	}

	private static void testFrench(BigDecimal n, int f, String expected)
	{
		System.out.println(Converter.convertToFrench(new BigDecimal(n + "." + f), "EGP"));
		System.out.println(expected);
	}
}
