package com.namasoft.specialserialization;

import com.namasoft.common.constants.*;
import com.namasoft.common.utilities.CollectionsUtility;
import io.github.classgraph.ScanResult;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class EntityModulesUtil implements ReflectionScanningUtil
{
	private static ConcurrentHashMap<Class<? extends ModuleEntities>, List<String>> allModulesEntities = new ConcurrentHashMap<>();
	private static ConcurrentHashMap<Class<? extends ModuleEntities>, String> actualModuleNames = new ConcurrentHashMap<>();
	private static List<String> allEntitiesSorted = new ArrayList<>();
	private static List<String> allModulesSorted = new ArrayList();

	public static List<String> getAllEntitiesSorted()
	{
		return allEntitiesSorted;
	}

	public static List<String> getAllModulesSorted()
	{
		return allModulesSorted;
	}

	@Override
	public void doSetup()
	{
		Set<Class<? extends ModuleEntities>> moduleEntityClasses = ScanningUtils.getSubTypesOf(ModuleEntities.class);
		HashSet<String> allEntities = new HashSet<String>();
		for (Class<? extends ModuleEntities> klass : moduleEntityClasses)
		{
			List<String> moduleEntities = ReflectionUtils.classFieldsToList(klass);
			allEntities.addAll(moduleEntities);
			allModulesEntities.put(klass, moduleEntities);
		}
		allEntitiesSorted = new ArrayList<>(allEntities);
		CollectionsUtility.sort(allEntitiesSorted);

		HashSet<String> allModules = new HashSet<>();
		allModules.addAll(ReflectionUtils.classFieldsToList(ModuleNames.class));
		allModulesSorted = new ArrayList<>(allModules);
		CollectionsUtility.sort(allModulesSorted);
		actualModuleNames.put(ECPAEntities.class, ModuleNames.ECPA);
		actualModuleNames.put(JobOrderEntities.class, ModuleNames.JOBORDER);
		actualModuleNames.put(MCEntities.class, ModuleNames.MC);
		actualModuleNames.put(ACCEntities.class, ModuleNames.ACCOUNTING);
		actualModuleNames.put(HREntities.class, ModuleNames.HR);
		actualModuleNames.put(DomainBaseEntities.class, ModuleNames.BASIC);
		actualModuleNames.put(CONTRACTINGEntities.class, ModuleNames.CONTRACTING);
		actualModuleNames.put(ServiceCenterEntities.class, ModuleNames.SERVICE_CENTER);
		actualModuleNames.put(travelEntities.class, ModuleNames.TRAVEL);
		actualModuleNames.put(EducationEntities.class, ModuleNames.EDUCATION);
		actualModuleNames.put(POSEntities.class, ModuleNames.POS);
		actualModuleNames.put(auditingEntities.class, ModuleNames.AUDITING);
		actualModuleNames.put(BSCEntities.class, ModuleNames.BASIC);
		actualModuleNames.put(CRMEntities.class, ModuleNames.CRM);
		actualModuleNames.put(ManufacturingEntities.class, ModuleNames.MANUFACTURING);
		actualModuleNames.put(FAEntities.class, ModuleNames.FIXED_ASSETS);
		actualModuleNames.put(SCEntities.class, ModuleNames.SUPPLY_CHAIN);
		actualModuleNames.put(HOEntities.class, ModuleNames.HOUSING);
		actualModuleNames.put(REEntities.class, ModuleNames.REAL_ESTATE);
		actualModuleNames.put(FRMEntities.class, ModuleNames.FRM);
	}

	@Override
	public int order()
	{
		return 0;
	}

	public static String getModuleNameOf(String entityType)
	{
		//Supply chain is a special case because many modules depend on it
		if (allModulesEntities.get(SCEntities.class).contains(entityType))
			return ModuleNames.SUPPLY_CHAIN;
		for (Map.Entry<Class<? extends ModuleEntities>, List<String>> entry : allModulesEntities.entrySet())
		{
			if (entry.getValue().contains(entityType))
				return actualModuleNames.get(entry.getKey());
		}
		return "";
	}
}
