package com.namasoft.specialserialization;

import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.utilities.*;

import java.io.*;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;

public class GenericValueAssistantImpl implements GenericValueAssistant
{
	private JSONAndDTOProvider provider;
	public GenericValueAssistantImpl(JSONAndDTOProvider provider)
	{
		this.provider = provider;
	}

	@Override
	public Object gui2FlatObject(GenericValue genericValue)
	{
		if (ObjectChecker.isEmptyOrNull(genericValue.getJsonData()))
			return null;
		try
		{
			Class klass = null;
			if (ObjectChecker.isNotEmptyOrNull(genericValue.getGui2ClassName()))
			{
				klass = Class.forName(genericValue.getGui2ClassName());
			}
			else
			{
				Class entityDTOClass = provider.getDTOClassFor(genericValue.getGui2EntityType());
				String[] parts = genericValue.getFieldId().split(Pattern.quote("."));
				Class current = entityDTOClass;
				for (String s : parts)
				{
					Method method = ReflectionUtils.tryGetMethod(current, "get" + StringUtils.firstLetterUpper(s));
					if (method == null)
						method = ReflectionUtils.tryGetMethod(current, "is" + StringUtils.firstLetterUpper(s));
					if (method == null)
						return null;
					klass = current = method.getReturnType();
					if (List.class.isAssignableFrom(klass))
						klass = current = ReflectionUtils.getMethodActualReturnType(method);
				}
			}
			if (klass == null)
				return null;
			return FlatObjectUtilies.createFlatObject(provider.readJSON(genericValue.getJsonData(), klass), 0);
		}
		catch (Exception e)
		{
			if (e instanceof RuntimeException)
				throw (RuntimeException) e;
			throw new NaMaServiceExcepption(e);
		}
	}

	@Override
	public Object gui2List(GenericValue genericValue)
	{
		if (ObjectChecker.isEmptyOrNull(genericValue.getJsonData()))
			return null;
		try
		{
			Class klass = Class.forName(genericValue.getGui2ClassName());
			return provider.readListJSON(genericValue.getJsonData(),klass);
		}
		catch (Exception e)
		{
			throw new NaMaServiceExcepption(e);
		}
	}

	@Override
	public Object gui2WholeEntity(GenericValue genericValue)
	{
		try
		{
			return FlatObjectUtilies
					.createFlatObject(provider.readJSON(genericValue.getJsonData(), provider.getDTOClassFor(genericValue.getGui2EntityType())));
		}
		catch (IOException e)
		{
			throw new NaMaServiceExcepption(e);
		}
	}

	@Override
	public String toJSON(Object o)
	{
		return provider.toJSON(o);
	}

	@Override
	public void writeAsJSONToFile(Object o, String file)
	{
		try
		{
			provider.writeAsJSONToFile(o, new File(file));
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}

	@Override
	public void writeAsPrettyJSONToFile(Object o, String file)
	{
		try
		{
			provider.writeAsPrettyJSONToFile(o, new File(file));
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}

	@Override
	public Object readAsJSONFromFile(String fileName, Class<?> klass)
	{
		try
		{
			return provider.readJSONFromFile(fileName, klass);
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}

	@Override
	public Object readJSON(String json, Class<?> klass)
	{
		try
		{
			return provider.readJSON(json, klass);
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}

	@Override
	public void setCurrentLoginInfoFromRequest(IServiceRequest request)
	{
		provider.setCurrentLoginInfoFromRequest(request);
	}

	@Override
	public void cleanupCurrentLoginInfo()
	{
		provider.cleanupCurrentLoginInfo();
	}
}
