package com.namasoft.taxauthority;

import com.namasoft.common.utilities.CollectionsUtility;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ TaxAuthorityExportInvoice.class, TaxAuthorityExportDebitNote.class, TaxAuthorityExportCreditNote.class })
public abstract class TaxAuthorityAbsExportDocument extends TaxAuthorityDocument
{
	private TaxAuthorityExportIssuer issuer;
	private String serviceDeliveryDate;
	private List<TaxAuthorityExportInvoiceLine> invoiceLines;

	public TaxAuthorityExportIssuer getIssuer()
	{
		return issuer;
	}

	public void setIssuer(TaxAuthorityExportIssuer issuer)
	{
		this.issuer = issuer;
	}

	public List<TaxAuthorityExportInvoiceLine> getInvoiceLines()
	{
		return invoiceLines;
	}

	public void setInvoiceLines(List<TaxAuthorityExportInvoiceLine> invoiceLines)
	{
		this.invoiceLines = invoiceLines;
	}

	public String getServiceDeliveryDate()
	{
		return serviceDeliveryDate;
	}

	public void setServiceDeliveryDate(String serviceDeliveryDate)
	{
		this.serviceDeliveryDate = serviceDeliveryDate;
	}

	@Override
	public void updateServiceDeliveryDate(String serviceDeliveryDate)
	{
		setServiceDeliveryDate(serviceDeliveryDate);
	}

	@Override
	public boolean exportDocument()
	{
		return true;
	}

	@Override
	public void updateLines(List<? extends EInvoiceDocLine> lines)
	{
		setInvoiceLines(CollectionsUtility.castList(lines));
	}

	@Override
	public <T extends EInvoiceDocLine> List<T> fetchLines()
	{
		return CollectionsUtility.castList(lines());
	}

	public <T extends EInvoiceDocLine> List<T> lines()
	{
		if (getInvoiceLines() == null)
			setInvoiceLines(new ArrayList<>());
		return CollectionsUtility.castList(getInvoiceLines());
	}

	@Override
	public <T extends EInvoiceDocLine> void addLine(T line)
	{
		lines().add(line);
	}

	@Override
	public TaxAuthorityEntityWithAddress createIssuer()
	{
		return new TaxAuthorityExportIssuer();
	}

	@Override
	public TaxAuthorityEntityWithAddress fetchIssuer()
	{
		return getIssuer();
	}

	@Override
	public void updateIssuer(TaxAuthorityEntityWithAddress issuer)
	{
		setIssuer((TaxAuthorityExportIssuer) issuer);
	}

	@Override
	public <T extends EInvoiceDocLine> T createLine()
	{
		return (T) new TaxAuthorityExportInvoiceLine();
	}
}