package com.namasoft.taxauthority.jordan;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.*;
import com.namasoft.taxauthority.*;
import com.namasoft.taxauthority.ublinvoice.UBLAbsEInvoice;
import jakarta.xml.bind.annotation.*;

import java.util.Map;

@XmlRootElement(name = "Invoice")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso(value = { JoFotaraInvoice.class, JoFotaraInvoiceReturn.class })
public abstract class AbsJoFotaraInvoice extends UBLAbsEInvoice
{
	public static Map<JoFotaraInvoiceType, Pair<String, String>> invoiceTransactionCodesCashAndSubsidiary = CollectionsUtility.map(
			JoFotaraInvoiceType.Income, new Pair<>("011", "021"), JoFotaraInvoiceType.Public, new Pair<>("012", "022"), JoFotaraInvoiceType.Private,
			new Pair<>("013", "023"));
	private JoFotaraInvoiceType joFotaraInvoiceType;

	public AbsJoFotaraInvoice()
	{
		setJoFotaraInvoiceType(JoFotaraInvoiceType.Public);
	}

	public JoFotaraInvoiceType getJoFotaraInvoiceType()
	{
		return joFotaraInvoiceType;
	}

	public void setJoFotaraInvoiceType(JoFotaraInvoiceType joFotaraInvoiceType)
	{
		this.joFotaraInvoiceType = joFotaraInvoiceType;
	}

	@Override
	public EInvoiceCountry invoiceCountry()
	{
		return EInvoiceCountry.Jordan;
	}

	@Override
	public String defaultCurrency()
	{
		return "JOD";
	}

	@Override
	public String defaultTaxCurrency()
	{
		return "JOD";
	}

	@Override
	public void updateInvoiceTransactionCode()
	{
		Pair<String, String> pair = invoiceTransactionCodesCashAndSubsidiary.get(getJoFotaraInvoiceType());
		String invoiceTransactionCode = pair.getY();
		if (isCashPaymentMethod())
			invoiceTransactionCode = pair.getX();
		setInvoiceTransactionCode(invoiceTransactionCode);
	}

	@Override
	public void updateReceiverIdentityType(TaxAuthorityReceiver receiver)
	{
		if (ObjectChecker.areEqual(receiver.getType(), "B"))
			customer().setIdentityType("TN");
		else if (ObjectChecker.areEqual(receiver.getType(), "P"))
			customer().setIdentityType("NIN");
		else
			customer().setIdentityType("PN");
	}

	@Override
	public boolean joFotaraPortal()
	{
		return true;
	}

	@Override
	public String fetchExemptionCode()
	{
		return "Z";
	}

	@Override
	public String fetchDocumentCurrencyCodeForXML()
	{
		return getTaxCurrencyCode();
	}
}
