package com.namasoft.taxauthority.ksa.entities;

import com.namasoft.taxauthority.*;
import com.namasoft.taxauthority.ublinvoice.UBLAbsEInvoice;

import jakarta.xml.bind.annotation.*;

@XmlRootElement(name = "Invoice")
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class ZATCAAbsEInvoice extends UBLAbsEInvoice
{
	private String previousInvoiceHash;
	@Override
	public EInvoiceCountry invoiceCountry()
	{
		return EInvoiceCountry.KSA;
	}

	@Override
	public String defaultTaxCurrency()
	{
		return "SAR";
	}

	@Override
	public String defaultCurrency()
	{
		return "SAR";
	}

	@Override
	public void updatePreviousInvoiceHash(String previousInvoiceHash)
	{
		setPreviousInvoiceHash(previousInvoiceHash);
	}

	public String getPreviousInvoiceHash()
	{
		return previousInvoiceHash;
	}

	public void setPreviousInvoiceHash(String previousInvoiceHash)
	{
		this.previousInvoiceHash = previousInvoiceHash;
	}

	@Override
	public String fetchPreviousInvoiceHash()
	{
		return getPreviousInvoiceHash();
	}

	@Override
	public void updateInvoiceTransactionCode()
	{
		setInvoiceTransactionCode(isPersonReceiver() ? "0200000" : "0100000");
	}

	@Override
	public void updateReceiverIdentityType(TaxAuthorityReceiver receiver)
	{
		customer().setIdentityType("CRN");
	}

	@Override
	public boolean shouldRoundPayableAmount()
	{
		return true;
	}

	@Override
	public int taxScale()
	{
		return 2;
	}

	@Override
	public boolean zatcaPortal()
	{
		return true;
	}
}
