package com.namasoft.contracts.common.dtos;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.modules.commonbasic.contracts.details.DTOAllowedBook;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTODocumentTermInfo;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTODocumentTerm extends MasterFileDTO
{
	private String documentType;
	private String altCode;
	private FlatObject termConfig;
	private List<DTOAllowedBook> allowedBooks;
	private Boolean systemBookOrTerm;
	private Boolean inActive;
	private String booksIDs;
	private String termConfigStr;
	private EntityReferenceData filters;
	private EntityReferenceData template;
	private DTODocumentTermInfo termInfo;

	public String getTermConfigStr()
	{
		return termConfigStr;
	}

	public void setTermConfigStr(String termConfigStr)
	{
		this.termConfigStr = termConfigStr;
	}

	public String getDocumentType()
	{
		return documentType;
	}

	public void setDocumentType(String documentType)
	{
		this.documentType = documentType;
	}

	public FlatObject getTermConfig()
	{
		return termConfig;
	}

	public void setTermConfig(FlatObject termConfig)
	{
		this.termConfig = termConfig;
	}

	public String getAltCode()
	{
		return altCode;
	}

	public void setAltCode(String altCode)
	{
		this.altCode = altCode;
	}

	public List<DTOAllowedBook> getAllowedBooks()
	{
		return allowedBooks;
	}

	public void setAllowedBooks(List<DTOAllowedBook> allowedBooks)
	{
		this.allowedBooks = allowedBooks;
	}

	public Boolean getSystemBookOrTerm()
	{
		return systemBookOrTerm;
	}

	public void setSystemBookOrTerm(Boolean systemBookOrTerm)
	{
		this.systemBookOrTerm = systemBookOrTerm;
	}

	public String getBooksIDs()
	{
		return booksIDs;
	}

	public void setBooksIDs(String booksIDs)
	{
		this.booksIDs = booksIDs;
	}

	public Boolean getInActive()
	{
		return inActive;
	}

	public void setInActive(Boolean inActive)
	{
		this.inActive = inActive;
	}

	public EntityReferenceData getFilters()
	{
		return filters;
	}

	public void setFilters(EntityReferenceData filters)
	{
		this.filters = filters;
	}

	public EntityReferenceData getTemplate()
	{
		return template;
	}

	public void setTemplate(EntityReferenceData template)
	{
		this.template = template;
	}

	public DTODocumentTermInfo getTermInfo()
	{
		return termInfo;
	}

	public void setTermInfo(DTODocumentTermInfo termInfo)
	{
		this.termInfo = termInfo;
	}

	@Override
	public String fetchDocTypeOrForTypeForBook_Term_Group()
	{
		return documentType;
	}
}
