package com.namasoft.contracts.common.dtos;

import java.util.Date;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.constants.GenerationType;
import com.namasoft.common.flatobjects.EntityReferenceData;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class DTOEntitySystemEntry extends NaMaDTO
{
	private String id;
	private String targetId;
	private String targetType;
	private EntityReferenceData legalEntity;
	private EntityReferenceData sector;
	private EntityReferenceData branch;
	private EntityReferenceData department;
	private EntityReferenceData analysisSet;
	private Date creationDate;
	private Date lastUpdateDate;
	private String code;
	private String altCode;
	private String moduleId;
	private String name1;
	private String name2;
	private GenerationType generationType;
	private String createTransactionId;
	private String lastModifyTransactionId;
	private String fromId;
	private String fromType;
	private String reviseLevel;
	private Boolean shouldSentToTaxAuthority;
	private String taxAuthEntityStatus;

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getTargetId()
	{
		return targetId;
	}

	public void setTargetId(String targetId)
	{
		this.targetId = targetId;
	}

	public String getTargetType()
	{
		return targetType;
	}

	public void setTargetType(String targetType)
	{
		this.targetType = targetType;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public EntityReferenceData getSector()
	{
		return sector;
	}

	public void setSector(EntityReferenceData sector)
	{
		this.sector = sector;
	}

	public EntityReferenceData getBranch()
	{
		return branch;
	}

	public void setBranch(EntityReferenceData branch)
	{
		this.branch = branch;
	}

	public EntityReferenceData getDepartment()
	{
		return department;
	}

	public void setDepartment(EntityReferenceData department)
	{
		this.department = department;
	}

	public EntityReferenceData getAnalysisSet()
	{
		return analysisSet;
	}

	public void setAnalysisSet(EntityReferenceData analysisSet)
	{
		this.analysisSet = analysisSet;
	}

	public Date getCreationDate()
	{
		return creationDate;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public Date getLastUpdateDate()
	{
		return lastUpdateDate;
	}

	public void setLastUpdateDate(Date lastUpdateDate)
	{
		this.lastUpdateDate = lastUpdateDate;
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	public String getAltCode()
	{
		return altCode;
	}

	public void setAltCode(String altCode)
	{
		this.altCode = altCode;
	}

	public String getModuleId()
	{
		return moduleId;
	}

	public void setModuleId(String moduleId)
	{
		this.moduleId = moduleId;
	}

	public String getName1()
	{
		return name1;
	}

	public void setName1(String name1)
	{
		this.name1 = name1;
	}

	public String getName2()
	{
		return name2;
	}

	public void setName2(String name2)
	{
		this.name2 = name2;
	}

	public GenerationType getGenerationType()
	{
		return generationType;
	}

	public void setGenerationType(GenerationType generationType)
	{
		this.generationType = generationType;
	}

	public String getCreateTransactionId()
	{
		return createTransactionId;
	}

	public void setCreateTransactionId(String createTransactionId)
	{
		this.createTransactionId = createTransactionId;
	}

	public String getLastModifyTransactionId()
	{
		return lastModifyTransactionId;
	}

	public void setLastModifyTransactionId(String lastModifyTransactionId)
	{
		this.lastModifyTransactionId = lastModifyTransactionId;
	}

	public String getFromId()
	{
		return fromId;
	}

	public void setFromId(String fromId)
	{
		this.fromId = fromId;
	}

	public String getFromType()
	{
		return fromType;
	}

	public void setFromType(String fromType)
	{
		this.fromType = fromType;
	}

	public String getReviseLevel()
	{
		return reviseLevel;
	}

	public void setReviseLevel(String reviseLevel)
	{
		this.reviseLevel = reviseLevel;
	}

	public Boolean getShouldSentToTaxAuthority()
	{
		return shouldSentToTaxAuthority;
	}

	public void setShouldSentToTaxAuthority(Boolean shouldSentToTaxAuthority)
	{
		this.shouldSentToTaxAuthority = shouldSentToTaxAuthority;
	}

	public String getTaxAuthEntityStatus()
	{
		return taxAuthEntityStatus;
	}

	public void setTaxAuthEntityStatus(String taxAuthEntityStatus)
	{
		this.taxAuthEntityStatus = taxAuthEntityStatus;
	}
}
