package com.namasoft.contracts.common.dtos;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOPageData implements Serializable
{
	public static final int SUGGESTION_ITEMS_COUNT = 15;
	public static final int ALL_RECORDS = -1;
	private static final long serialVersionUID = -5042065744959820722L;
	private int pageSize;
	private int pageNumber;
	private int pagesCount;

	public DTOPageData()
	{

	}

	public DTOPageData(int pageNumber, int pageSize)
	{
		this.pageNumber = pageNumber;
		this.pageSize = pageSize;
	}

	public int getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(int pageSize)
	{
		this.pageSize = pageSize;
	}

	public int getPageNumber()
	{
		return pageNumber;
	}

	public void setPageNumber(int pageNumber)
	{
		this.pageNumber = pageNumber;
	}

	public int getPagesCount()
	{
		return pagesCount;
	}

	public void setPagesCount(int pagesCount)
	{
		this.pagesCount = pagesCount;
	}

	public static DTOPageData all()
	{
		return new DTOPageData(0, -1);
	}

	public static DTOPageData firstPage(int recordsCount)
	{
		return new DTOPageData(0, recordsCount);
	}

	public DTOPageData firstPage()
	{
		pageNumber = 0;
		return this;
	}

	public DTOPageData lastPage()
	{
		if (pagesCount > 0)
			pageNumber = pagesCount - 1;
		return this;
	}

	public DTOPageData nextPage()
	{
		if (pageNumber < pagesCount)
			pageNumber++;
		return this;
	}

	public DTOPageData previousPage()
	{
		if (pageNumber > 0)
			pageNumber--;
		return this;
	}
	public static DTOPageData lastRecord()
	{
		return new DTOPageData(Integer.MAX_VALUE, 1);
	}
}
