package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.criteria.DTOCriteriaBuilder;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.ObjectChecker;

import java.text.*;
import java.util.Date;

public class AGGridDateFilterModel extends AGGridISimpleFilterModel
{
	private String dateFrom;
	private String dateTo;

	public AGGridDateFilterModel()
	{
	}

	@Override
	public void appendExpression(DTOCriteriaBuilder.DTOExpressionBuilder expressionBuilder, String fieldId, String fieldType)
	{
		DTOCriteriaBuilder.DTOExpressionBuilder exp = expressionBuilder.and().field(fieldId);
		String parsedDateFrom = "";
		String parsedDateTo = "";
		try
		{
			if (ObjectChecker.isNotEmptyOrNull(dateFrom))
			{
				Date dateFromParsed = new SimpleDateFormat(fetchInputPattern(fieldType)).parse(dateFrom);
				parsedDateFrom = new SimpleDateFormat(fetchOutputPattern(fieldType)).format(dateFromParsed);
			}
			if (ObjectChecker.isNotEmptyOrNull(dateTo))
			{
				Date dateToParsed = new SimpleDateFormat(fetchInputPattern(fieldType)).parse(dateTo);
				parsedDateTo = new SimpleDateFormat(fetchOutputPattern(fieldType)).format(dateToParsed);
			}
		}
		catch (ParseException e)
		{
			throw new NaMaServiceExcepption(e);
		}
		switch (getType())
		{
		case blank -> exp.isNull();
		case notBlank -> exp.isNotNull();
		case equals -> exp.equal(parsedDateFrom);
		case notEqual -> exp.notEqual(parsedDateFrom);
		case lessThan, before -> exp.lessThan(parsedDateFrom);
		case greaterThan, after -> exp.greaterThan(parsedDateFrom);
		case inRange, between -> exp.greaterThanOrEqual(parsedDateFrom).and().field(fieldId).lessThanOrEqual(parsedDateTo);
		}
	}

	private String fetchOutputPattern(String fieldType)
	{
		if (ObjectChecker.areEqual(fieldType, FieldType.DateAndTime.name()))
			return "yyyy-MM-dd'T'HH:mm:ss.SSS";
		if (ObjectChecker.areEqual(fieldType, FieldType.Time.name()))
			return "HH:mm:ss.SSS";
		return "dd-MM-yyyy";
	}

	private String fetchInputPattern(String fieldType)
	{
		if (ObjectChecker.isAnyEqualToFirst(fieldType, FieldType.DateAndTime.name(), FieldType.Time.name()))
			return "yyyy-MM-dd HH:mm:ss.SSS";
		return "yyyy-MM-dd HH:mm:ss";
	}

	public String getDateFrom()
	{
		return dateFrom;
	}

	public void setDateFrom(String dateFrom)
	{
		this.dateFrom = dateFrom;
	}

	public String getDateTo()
	{
		return dateTo;
	}

	public void setDateTo(String dateTo)
	{
		this.dateTo = dateTo;
	}
}
