package com.namasoft.contracts.common.dtos.requests;

import com.fasterxml.jackson.annotation.*;
import jakarta.xml.bind.annotation.*;

@XmlRootElement
@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ AGGridMultiFilterModel.class, AGGridDateFilterModel.class, AGGridTextFilterModel.class, AGGridNumberFilterModel.class,
		AGGridReferenceFilterModel.class, AGGridSetFilterModel.class })
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "filterType")
@JsonSubTypes({ @JsonSubTypes.Type(value = AGGridMultiFilterModel.class, name = "multi"),
		@JsonSubTypes.Type(value = AGGridDateFilterModel.class, name = "date"),
		@JsonSubTypes.Type(value = AGGridTextFilterModel.class, name = "text"),
		@JsonSubTypes.Type(value = AGGridReferenceFilterModel.class, name = "reference"),
		@JsonSubTypes.Type(value = AGGridSetFilterModel.class, name = "set"),
		@JsonSubTypes.Type(value = AGGridNumberFilterModel.class, name = "number") })
public abstract class AGGridProvidedFilterModel
{
	private String filterType;

	public AGGridProvidedFilterModel()
	{
	}

	public String getFilterType()
	{
		return filterType;
	}

	public void setFilterType(String filterType)
	{
		this.filterType = filterType;
	}
}
